/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.encryption;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public record EncryptionKey(byte[] key, String algorithm) {
    public EncryptionKey {
        Objects.requireNonNull(algorithm, "algorithm is null");
        Objects.requireNonNull(key, "key is null");
    }

    public static EncryptionKey randomAes256() {
        byte[] key = new byte[32];
        ThreadLocalRandom.current().nextBytes(key);
        return new EncryptionKey(key, "AES256");
    }

    @Override
    public String toString() {
        return this.algorithm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptionKey)) {
            return false;
        }
        EncryptionKey that = (EncryptionKey)o;
        return Objects.deepEquals(this.key, that.key) && Objects.equals(this.algorithm, that.algorithm);
    }

    @Override
    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.key), this.algorithm);
    }
}

