/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.common.base.Preconditions;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.encryption.EncryptionKey;
import io.trino.filesystem.gcs.GcsLocation;
import io.trino.filesystem.gcs.GcsUtils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

final class GcsInput
implements TrinoInput {
    private final GcsLocation location;
    private final Storage storage;
    private final int readBlockSize;
    private final OptionalLong length;
    private final Optional<EncryptionKey> key;
    private boolean closed;

    public GcsInput(GcsLocation location, Storage storage, int readBlockSize, OptionalLong length, Optional<EncryptionKey> key) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.storage = Objects.requireNonNull(storage, "storage is null");
        Preconditions.checkArgument((readBlockSize >= 0 ? 1 : 0) != 0, (Object)"readBlockSize is negative");
        this.readBlockSize = readBlockSize;
        this.length = Objects.requireNonNull(length, "length is null");
        this.key = Objects.requireNonNull(key, "key is null");
    }

    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.ensureOpen();
        if (position < 0L) {
            throw new IOException("Negative seek offset");
        }
        Objects.checkFromIndexSize(bufferOffset, bufferLength, buffer.length);
        if (bufferLength == 0) {
            return;
        }
        try (ReadChannel readChannel = GcsUtils.getReadChannel(GcsUtils.getBlobOrThrow(this.storage, this.location, this.blobGetOptions()), this.location, position, this.readBlockSize, this.length, this.key);){
            int readSize = this.readNBytes(readChannel, buffer, bufferOffset, bufferLength);
            if (readSize != bufferLength) {
                throw new EOFException("End of file reached before reading fully: " + String.valueOf(this.location));
            }
        }
        catch (RuntimeException e) {
            throw GcsUtils.handleGcsException(e, "reading file", this.location);
        }
    }

    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        int n;
        block8: {
            this.ensureOpen();
            Objects.checkFromIndexSize(bufferOffset, bufferLength, buffer.length);
            Blob blob = GcsUtils.getBlobOrThrow(this.storage, this.location, this.blobGetOptions());
            long offset = Math.max(0L, this.length.orElse(blob.getSize()) - (long)bufferLength);
            ReadChannel readChannel = GcsUtils.getReadChannel(blob, this.location, offset, this.readBlockSize, this.length, this.key);
            try {
                n = this.readNBytes(readChannel, buffer, bufferOffset, bufferLength);
                if (readChannel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (readChannel != null) {
                        try {
                            readChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw GcsUtils.handleGcsException(e, "reading file", this.location);
                }
            }
            readChannel.close();
        }
        return n;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream closed: " + String.valueOf(this.location));
        }
    }

    public void close() {
        this.closed = true;
    }

    public String toString() {
        return this.location.toString();
    }

    private int readNBytes(ReadChannel readChannel, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        int readSize;
        int bytesRead;
        ByteBuffer wrappedBuffer = ByteBuffer.wrap(buffer, bufferOffset, bufferLength);
        for (readSize = 0; readSize < bufferLength && (bytesRead = readChannel.read(wrappedBuffer)) != -1; readSize += bytesRead) {
        }
        return readSize;
    }

    /*
     * Exception decompiling
     */
    private Storage.BlobGetOption[] blobGetOptions() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Storage.BlobGetOption[] lambda$blobGetOptions$1() {
        return new Storage.BlobGetOption[0];
    }
}

