/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.cloud.WriteChannel;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.encryption.EncryptionKey;
import io.trino.filesystem.gcs.GcsLocation;
import io.trino.filesystem.gcs.GcsOutputStream;
import io.trino.filesystem.gcs.GcsUtils;
import io.trino.memory.context.AggregatedMemoryContext;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.Objects;
import java.util.Optional;

public class GcsOutputFile
implements TrinoOutputFile {
    private final GcsLocation location;
    private final Storage storage;
    private final long writeBlockSizeBytes;
    private final Optional<EncryptionKey> key;

    public GcsOutputFile(GcsLocation location, Storage storage, long writeBlockSizeBytes, Optional<EncryptionKey> key) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.storage = Objects.requireNonNull(storage, "storage is null");
        Preconditions.checkArgument((writeBlockSizeBytes >= 0L ? 1 : 0) != 0, (Object)"writeBlockSizeBytes is negative");
        this.writeBlockSizeBytes = writeBlockSizeBytes;
        this.key = Objects.requireNonNull(key, "key is null");
    }

    public void createOrOverwrite(byte[] data) throws IOException {
        try {
            this.storage.create(this.blobInfo(), data, this.blobTargetOptions(false));
        }
        catch (RuntimeException e) {
            throw GcsUtils.handleGcsException(e, "writing file", this.location);
        }
    }

    public void createExclusive(byte[] data) throws IOException {
        try {
            this.storage.create(this.blobInfo(), data, this.blobTargetOptions(true));
        }
        catch (RuntimeException e) {
            this.throwIfAlreadyExists(e);
            throw GcsUtils.handleGcsException(e, "writing file", this.location);
        }
    }

    public OutputStream create(AggregatedMemoryContext memoryContext) throws IOException {
        try {
            WriteChannel writeChannel = this.storage.writer(this.blobInfo(), this.blobWriteOptions(true));
            return new GcsOutputStream(this.location, writeChannel, memoryContext, this.writeBlockSizeBytes);
        }
        catch (RuntimeException e) {
            this.throwIfAlreadyExists(e);
            throw GcsUtils.handleGcsException(e, "writing file", this.location);
        }
    }

    public Location location() {
        return this.location.location();
    }

    private BlobInfo blobInfo() {
        return BlobInfo.newBuilder((String)this.location.bucket(), (String)this.location.path()).build();
    }

    private Storage.BlobWriteOption[] blobWriteOptions(boolean doesNotExist) {
        ImmutableList.Builder options = ImmutableList.builder();
        if (doesNotExist) {
            options.add((Object)Storage.BlobWriteOption.doesNotExist());
        }
        this.key.ifPresent(arg_0 -> GcsOutputFile.lambda$blobWriteOptions$0((ImmutableCollection.Builder)options, arg_0));
        return (Storage.BlobWriteOption[])options.build().toArray((Object[])new Storage.BlobWriteOption[0]);
    }

    private Storage.BlobTargetOption[] blobTargetOptions(boolean doesNotExist) {
        ImmutableList.Builder options = ImmutableList.builder();
        if (doesNotExist) {
            options.add((Object)Storage.BlobTargetOption.doesNotExist());
        }
        this.key.ifPresent(arg_0 -> GcsOutputFile.lambda$blobTargetOptions$0((ImmutableCollection.Builder)options, arg_0));
        return (Storage.BlobTargetOption[])options.build().toArray((Object[])new Storage.BlobTargetOption[0]);
    }

    private void throwIfAlreadyExists(RuntimeException e) throws FileAlreadyExistsException {
        StorageException se;
        if (e instanceof StorageException && (se = (StorageException)e).getCode() == 412) {
            throw new FileAlreadyExistsException(this.location.toString());
        }
    }

    private static /* synthetic */ void lambda$blobTargetOptions$0(ImmutableCollection.Builder options, EncryptionKey encryption) {
        options.add((Object)Storage.BlobTargetOption.encryptionKey((String)GcsUtils.encodedKey(encryption)));
    }

    private static /* synthetic */ void lambda$blobWriteOptions$0(ImmutableCollection.Builder options, EncryptionKey encryption) {
        options.add((Object)Storage.BlobWriteOption.encryptionKey((String)GcsUtils.encodedKey(encryption)));
    }
}

