/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigSecuritySensitive;
import jakarta.validation.constraints.AssertTrue;
import java.util.Optional;

public class AzureAuthManagedIdentityConfig {
    private Optional<String> clientId = Optional.empty();
    private Optional<String> resourceId = Optional.empty();

    public Optional<String> getClientId() {
        return this.clientId;
    }

    @ConfigSecuritySensitive
    @Config(value="azure.user-assigned-managed-identity.client-id")
    public AzureAuthManagedIdentityConfig setClientId(String clientId) {
        this.clientId = Optional.ofNullable(clientId);
        return this;
    }

    public Optional<String> getResourceId() {
        return this.resourceId;
    }

    @ConfigSecuritySensitive
    @Config(value="azure.user-assigned-managed-identity.resource-id")
    public AzureAuthManagedIdentityConfig setResourceId(String resourceId) {
        this.resourceId = Optional.ofNullable(resourceId);
        return this;
    }

    @AssertTrue(message="Both azure.user-assigned-managed-identity.client-id and azure.user-assigned-managed-identity.resource-id cannot be set")
    public @AssertTrue(message="Both azure.user-assigned-managed-identity.client-id and azure.user-assigned-managed-identity.resource-id cannot be set") boolean isConfigValid() {
        return this.clientId.isEmpty() || this.resourceId.isEmpty();
    }
}

