/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.partition;

import com.google.common.base.MoreObjects;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hudi.HudiUtil;
import io.trino.plugin.hudi.partition.HudiPartitionInfo;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.exception.HoodieIOException;

public class HiveHudiPartitionInfo
implements HudiPartitionInfo {
    private final Table table;
    private final List<HiveColumnHandle> partitionColumnHandles;
    private final TupleDomain<HiveColumnHandle> constraintSummary;
    private final String hivePartitionName;
    private final List<Column> partitionColumns;
    private final HiveMetastore hiveMetastore;
    private String relativePartitionPath;
    private List<HivePartitionKey> hivePartitionKeys;

    public HiveHudiPartitionInfo(String hivePartitionName, List<Column> partitionColumns, List<HiveColumnHandle> partitionColumnHandles, TupleDomain<HiveColumnHandle> constraintSummary, Table table, HiveMetastore hiveMetastore) {
        this.table = table;
        this.partitionColumnHandles = partitionColumnHandles;
        this.constraintSummary = constraintSummary;
        this.hivePartitionName = hivePartitionName;
        this.partitionColumns = partitionColumns;
        if (partitionColumns.isEmpty()) {
            this.relativePartitionPath = "";
            this.hivePartitionKeys = Collections.emptyList();
        }
        this.hiveMetastore = hiveMetastore;
    }

    @Override
    public Table getTable() {
        return null;
    }

    @Override
    public String getRelativePartitionPath() {
        if (this.relativePartitionPath == null) {
            this.loadPartitionInfo(this.hiveMetastore.getPartition(this.table, HiveUtil.toPartitionValues((String)this.hivePartitionName)));
        }
        return this.relativePartitionPath;
    }

    @Override
    public String getHivePartitionName() {
        return this.hivePartitionName;
    }

    @Override
    public List<HivePartitionKey> getHivePartitionKeys() {
        if (this.hivePartitionKeys == null) {
            this.loadPartitionInfo(this.hiveMetastore.getPartition(this.table, HiveUtil.toPartitionValues((String)this.hivePartitionName)));
        }
        return this.hivePartitionKeys;
    }

    @Override
    public boolean doesMatchPredicates() {
        return HudiUtil.partitionMatchesPredicates(this.table.getSchemaTableName(), this.hivePartitionName, this.partitionColumnHandles, this.constraintSummary);
    }

    @Override
    public String getComparingKey() {
        return this.hivePartitionName;
    }

    @Override
    public void loadPartitionInfo(Optional<Partition> partition) {
        if (partition.isEmpty()) {
            throw new HoodieIOException(String.format("Cannot find partition in Hive Metastore: %s", this.hivePartitionName));
        }
        this.relativePartitionPath = FSUtils.getRelativePartitionPath((Path)new Path(this.table.getStorage().getLocation()), (Path)new Path(partition.get().getStorage().getLocation()));
        this.hivePartitionKeys = HudiUtil.buildPartitionKeys(this.partitionColumns, partition.get().getValues());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hivePartitionName", (Object)this.hivePartitionName).add("hivePartitionKeys", this.hivePartitionKeys).toString();
    }
}

