/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.split;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hudi.HudiErrorCode;
import io.trino.plugin.hudi.HudiSplit;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.plugin.hudi.split.HudiSplitWeightProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.hadoop.PathWithBootstrapFileStatus;

public class HudiSplitFactory {
    private static final double SPLIT_SLOP = 1.1;
    private final HudiTableHandle hudiTableHandle;
    private final HudiSplitWeightProvider hudiSplitWeightProvider;

    public HudiSplitFactory(HudiTableHandle hudiTableHandle, HudiSplitWeightProvider hudiSplitWeightProvider) {
        this.hudiTableHandle = Objects.requireNonNull(hudiTableHandle, "hudiTableHandle is null");
        this.hudiSplitWeightProvider = Objects.requireNonNull(hudiSplitWeightProvider, "hudiSplitWeightProvider is null");
    }

    public Stream<HudiSplit> createSplits(List<HivePartitionKey> partitionKeys, FileStatus fileStatus) {
        List<FileSplit> splits;
        try {
            splits = this.createSplits(fileStatus);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_CANNOT_OPEN_SPLIT, (Throwable)e);
        }
        return splits.stream().map(fileSplit -> new HudiSplit(fileSplit.getPath().toString(), fileSplit.getStart(), fileSplit.getLength(), fileStatus.getLen(), fileStatus.getModificationTime(), (List<HostAddress>)ImmutableList.of(), this.hudiTableHandle.getRegularPredicates(), partitionKeys, this.hudiSplitWeightProvider.calculateSplitWeight(fileSplit.getLength())));
    }

    private List<FileSplit> createSplits(FileStatus fileStatus) throws IOException {
        if (fileStatus.isDirectory()) {
            throw new IOException("Not a file: " + fileStatus.getPath());
        }
        Path path = fileStatus.getPath();
        long length = fileStatus.getLen();
        if (length == 0L) {
            return ImmutableList.of((Object)new FileSplit(path, 0L, 0L, new String[0]));
        }
        if (!HudiSplitFactory.isSplitable(path)) {
            return ImmutableList.of((Object)new FileSplit(path, 0L, length, (String[])null));
        }
        ImmutableList.Builder splits = ImmutableList.builder();
        long splitSize = fileStatus.getBlockSize();
        long bytesRemaining = length;
        while ((double)bytesRemaining / (double)splitSize > 1.1) {
            splits.add((Object)new FileSplit(path, length - bytesRemaining, splitSize, (String[])null));
            bytesRemaining -= splitSize;
        }
        if (bytesRemaining != 0L) {
            splits.add((Object)new FileSplit(path, length - bytesRemaining, bytesRemaining, (String[])null));
        }
        return splits.build();
    }

    private static boolean isSplitable(Path filename) {
        return !(filename instanceof PathWithBootstrapFileStatus);
    }
}

