/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hudi.HudiMetadata;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class HudiMetadataFactory {
    private final HiveMetastoreFactory metastoreFactory;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;

    @Inject
    public HudiMetadataFactory(HiveMetastoreFactory metastoreFactory, HdfsEnvironment hdfsEnvironment, TypeManager typeManager) {
        this.metastoreFactory = Objects.requireNonNull(metastoreFactory, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public HudiMetadata create(ConnectorIdentity identity) {
        HiveMetastore metastore = this.metastoreFactory.createMetastore(Optional.of(identity));
        return new HudiMetadata(metastore, this.hdfsEnvironment, this.typeManager);
    }
}

