/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.collect.ImmutableMap;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitSource;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hudi.ForHudiSplitManager;
import io.trino.plugin.hudi.HudiConfig;
import io.trino.plugin.hudi.HudiMetadata;
import io.trino.plugin.hudi.HudiSplitSource;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.plugin.hudi.HudiTransactionManager;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;

public class HudiSplitManager
implements ConnectorSplitManager {
    private final HudiTransactionManager transactionManager;
    private final BiFunction<ConnectorIdentity, HiveTransactionHandle, HiveMetastore> metastoreProvider;
    private final HdfsEnvironment hdfsEnvironment;
    private final ExecutorService executor;
    private final int maxSplitsPerSecond;
    private final int maxOutstandingSplits;

    @Inject
    public HudiSplitManager(HudiTransactionManager transactionManager, BiFunction<ConnectorIdentity, HiveTransactionHandle, HiveMetastore> metastoreProvider, HdfsEnvironment hdfsEnvironment, @ForHudiSplitManager ExecutorService executor, HudiConfig hudiConfig) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastoreProvider is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.maxSplitsPerSecond = Objects.requireNonNull(hudiConfig, "hudiConfig is null").getMaxSplitsPerSecond();
        this.maxOutstandingSplits = hudiConfig.getMaxOutstandingSplits();
    }

    @PreDestroy
    public void destroy() {
        this.executor.shutdown();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle tableHandle, DynamicFilter dynamicFilter, Constraint constraint) {
        HudiTableHandle hudiTableHandle = (HudiTableHandle)tableHandle;
        HudiMetadata hudiMetadata = this.transactionManager.get(transaction, session.getIdentity());
        Map partitionColumnHandles = (Map)hudiMetadata.getColumnHandles(session, tableHandle).values().stream().map(HiveColumnHandle.class::cast).filter(HiveColumnHandle::isPartitionKey).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, Function.identity()));
        HiveMetastore metastore = this.metastoreProvider.apply(session.getIdentity(), (HiveTransactionHandle)transaction);
        Table table = (Table)metastore.getTable(hudiTableHandle.getSchemaName(), hudiTableHandle.getTableName()).orElseThrow(() -> new TableNotFoundException(SchemaTableName.schemaTableName((String)hudiTableHandle.getSchemaName(), (String)hudiTableHandle.getTableName())));
        HudiSplitSource splitSource = new HudiSplitSource(session, metastore, table, hudiTableHandle, this.hdfsEnvironment.getConfiguration(new HdfsContext(session), new Path(table.getStorage().getLocation())), partitionColumnHandles, this.executor, this.maxSplitsPerSecond, this.maxOutstandingSplits);
        return new ClassLoaderSafeConnectorSplitSource((ConnectorSplitSource)splitSource, HudiSplitManager.class.getClassLoader());
    }
}

