/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.collect.ImmutableList;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

public class HudiTableProperties {
    public static final String LOCATION_PROPERTY = "location";
    public static final String PARTITIONED_BY_PROPERTY = "partitioned_by";
    private final List<PropertyMetadata<?>> tableProperties = ImmutableList.builder().add((Object)PropertyMetadata.stringProperty((String)"location", (String)"File system location URI for the table", null, (boolean)false)).add((Object)new PropertyMetadata("partitioned_by", "Partition columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((Collection)value).stream().map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value)).build();

    @Inject
    public HudiTableProperties() {
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static Optional<String> getTableLocation(Map<String, Object> tableProperties) {
        return Optional.ofNullable((String)tableProperties.get(LOCATION_PROPERTY));
    }
}

