/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Locale;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class HudiConfig {
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private List<String> columnsToHide = ImmutableList.of();
    private boolean metadataEnabled;
    private boolean shouldUseParquetColumnNames = true;
    private int minPartitionBatchSize = 10;
    private int maxPartitionBatchSize = 100;
    private boolean sizeBasedSplitWeightsEnabled = true;
    private DataSize standardSplitWeightSize = DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private double minimumAssignedSplitWeight = 0.05;
    private int maxSplitsPerSecond = Integer.MAX_VALUE;
    private int maxOutstandingSplits = 1000;

    public List<String> getColumnsToHide() {
        return this.columnsToHide;
    }

    @Config(value="hudi.columns-to-hide")
    @ConfigDescription(value="List of column names that will be hidden from the query output. It can be used to hide Hudi meta fields. By default, no fields are hidden.")
    public HudiConfig setColumnsToHide(String columnsToHide) {
        this.columnsToHide = (List)COMMA_SPLITTER.splitToStream((CharSequence)Strings.nullToEmpty((String)columnsToHide)).map(s -> s.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
        return this;
    }

    @Config(value="hudi.metadata-enabled")
    @ConfigDescription(value="Fetch the list of file names and sizes from metadata rather than storage.")
    public HudiConfig setMetadataEnabled(boolean metadataEnabled) {
        this.metadataEnabled = metadataEnabled;
        return this;
    }

    public boolean isMetadataEnabled() {
        return this.metadataEnabled;
    }

    @Config(value="hudi.parquet.use-column-names")
    @ConfigDescription(value="Access Parquet columns using names from the file. If disabled, then columns are accessed using index.Only applicable to Parquet file format.")
    public HudiConfig setUseParquetColumnNames(boolean shouldUseParquetColumnNames) {
        this.shouldUseParquetColumnNames = shouldUseParquetColumnNames;
        return this;
    }

    public boolean getUseParquetColumnNames() {
        return this.shouldUseParquetColumnNames;
    }

    @Config(value="hudi.min-partition-batch-size")
    @ConfigDescription(value="Minimum number of partitions returned in a single batch.")
    public HudiConfig setMinPartitionBatchSize(int minPartitionBatchSize) {
        this.minPartitionBatchSize = minPartitionBatchSize;
        return this;
    }

    @Min(value=1L)
    @Max(value=100L)
    public @Min(value=1L) @Max(value=100L) int getMinPartitionBatchSize() {
        return this.minPartitionBatchSize;
    }

    @Config(value="hudi.max-partition-batch-size")
    @ConfigDescription(value="Maximum number of partitions returned in a single batch.")
    public HudiConfig setMaxPartitionBatchSize(int maxPartitionBatchSize) {
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        return this;
    }

    @Min(value=1L)
    @Max(value=1000L)
    public @Min(value=1L) @Max(value=1000L) int getMaxPartitionBatchSize() {
        return this.maxPartitionBatchSize;
    }

    @Config(value="hudi.size-based-split-weights-enabled")
    @ConfigDescription(value="Unlike uniform splitting, size-based splitting ensures that each batch of splits has enough data to process. By default, it is enabled to improve performance.")
    public HudiConfig setSizeBasedSplitWeightsEnabled(boolean sizeBasedSplitWeightsEnabled) {
        this.sizeBasedSplitWeightsEnabled = sizeBasedSplitWeightsEnabled;
        return this;
    }

    public boolean isSizeBasedSplitWeightsEnabled() {
        return this.sizeBasedSplitWeightsEnabled;
    }

    @Config(value="hudi.standard-split-weight-size")
    @ConfigDescription(value="The split size corresponding to the standard weight (1.0) when size based split weights are enabled.")
    public HudiConfig setStandardSplitWeightSize(DataSize standardSplitWeightSize) {
        this.standardSplitWeightSize = standardSplitWeightSize;
        return this;
    }

    @NotNull
    public DataSize getStandardSplitWeightSize() {
        return this.standardSplitWeightSize;
    }

    @Config(value="hudi.minimum-assigned-split-weight")
    @ConfigDescription(value="Minimum weight that a split can be assigned when size based split weights are enabled.")
    public HudiConfig setMinimumAssignedSplitWeight(double minimumAssignedSplitWeight) {
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        return this;
    }

    @DecimalMax(value="1")
    @DecimalMin(value="0", inclusive=false)
    public @DecimalMax(value="1") @DecimalMin(value="0", inclusive=false) double getMinimumAssignedSplitWeight() {
        return this.minimumAssignedSplitWeight;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxSplitsPerSecond() {
        return this.maxSplitsPerSecond;
    }

    @Config(value="hudi.max-splits-per-second")
    @ConfigDescription(value="Rate at which splits are enqueued for processing. The queue will throttle if this rate limit is breached.")
    public HudiConfig setMaxSplitsPerSecond(int maxSplitsPerSecond) {
        this.maxSplitsPerSecond = maxSplitsPerSecond;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxOutstandingSplits() {
        return this.maxOutstandingSplits;
    }

    @Config(value="hudi.max-outstanding-splits")
    @ConfigDescription(value="Maximum outstanding splits in a batch enqueued for processing.")
    public HudiConfig setMaxOutstandingSplits(int maxOutstandingSplits) {
        this.maxOutstandingSplits = maxOutstandingSplits;
        return this;
    }
}

