/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import io.airlift.slice.Slices;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.fs.Path;

public class HudiPageSource
implements ConnectorPageSource {
    private final Block[] prefilledBlocks;
    private final int[] delegateIndexes;
    private final ConnectorPageSource dataPageSource;

    public HudiPageSource(String partitionName, List<HiveColumnHandle> columnHandles, Map<String, Block> partitionBlocks, ConnectorPageSource dataPageSource, Path path, long fileSize, long fileModifiedTime) {
        Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.dataPageSource = Objects.requireNonNull(dataPageSource, "dataPageSource is null");
        int size = columnHandles.size();
        this.prefilledBlocks = new Block[size];
        this.delegateIndexes = new int[size];
        int outputIndex = 0;
        int delegateIndex = 0;
        for (HiveColumnHandle column : columnHandles) {
            if (partitionBlocks.containsKey(column.getName())) {
                Block partitionValue;
                this.prefilledBlocks[outputIndex] = partitionValue = partitionBlocks.get(column.getName());
                this.delegateIndexes[outputIndex] = -1;
            } else if (column.getName().equals("$partition")) {
                this.prefilledBlocks[outputIndex] = Utils.nativeValueToBlock((Type)HiveColumnHandle.PARTITION_TYPE_SIGNATURE, (Object)Slices.utf8Slice((String)partitionName));
                this.delegateIndexes[outputIndex] = -1;
            } else if (column.getName().equals("$path")) {
                this.prefilledBlocks[outputIndex] = Utils.nativeValueToBlock((Type)HiveColumnHandle.PATH_TYPE, (Object)Slices.utf8Slice((String)path.toString()));
                this.delegateIndexes[outputIndex] = -1;
            } else if (column.getName().equals("$file_size")) {
                this.prefilledBlocks[outputIndex] = Utils.nativeValueToBlock((Type)HiveColumnHandle.FILE_SIZE_TYPE_SIGNATURE, (Object)fileSize);
                this.delegateIndexes[outputIndex] = -1;
            } else if (column.getName().equals("$file_modified_time")) {
                long packedTimestamp = DateTimeEncoding.packDateTimeWithZone((long)fileModifiedTime, (TimeZoneKey)TimeZoneKey.UTC_KEY);
                this.prefilledBlocks[outputIndex] = Utils.nativeValueToBlock((Type)HiveColumnHandle.FILE_MODIFIED_TIME_TYPE_SIGNATURE, (Object)packedTimestamp);
                this.delegateIndexes[outputIndex] = -1;
            } else {
                this.delegateIndexes[outputIndex] = delegateIndex++;
            }
            ++outputIndex;
        }
    }

    public long getCompletedBytes() {
        return this.dataPageSource.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.dataPageSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.dataPageSource.isFinished();
    }

    public Page getNextPage() {
        try {
            Page page = this.dataPageSource.getNextPage();
            if (page == null) {
                return null;
            }
            int positionCount = page.getPositionCount();
            Block[] blocks = new Block[this.prefilledBlocks.length];
            for (int i = 0; i < this.prefilledBlocks.length; ++i) {
                blocks[i] = this.prefilledBlocks[i] != null ? RunLengthEncodedBlock.create((Block)this.prefilledBlocks[i], (int)positionCount) : page.getBlock(this.delegateIndexes[i]);
            }
            return new Page(positionCount, blocks);
        }
        catch (RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw e;
        }
    }

    public long getMemoryUsage() {
        return this.dataPageSource.getMemoryUsage();
    }

    public void close() throws IOException {
        this.dataPageSource.close();
    }
}

