/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hudi.HudiErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;

public final class HudiUtil {
    private HudiUtil() {
    }

    public static boolean isHudiParquetInputFormat(InputFormat<?, ?> inputFormat) {
        return inputFormat instanceof HoodieParquetInputFormat;
    }

    public static HoodieFileFormat getHudiFileFormat(String path) {
        String extension = FSUtils.getFileExtension((String)path);
        if (extension.equals(HoodieFileFormat.PARQUET.getFileExtension())) {
            return HoodieFileFormat.PARQUET;
        }
        if (extension.equals(HoodieFileFormat.HOODIE_LOG.getFileExtension())) {
            return HoodieFileFormat.HOODIE_LOG;
        }
        if (extension.equals(HoodieFileFormat.ORC.getFileExtension())) {
            return HoodieFileFormat.ORC;
        }
        if (extension.equals(HoodieFileFormat.HFILE.getFileExtension())) {
            return HoodieFileFormat.HFILE;
        }
        throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_UNSUPPORTED_FILE_FORMAT, "Hoodie InputFormat not implemented for base file of type " + extension);
    }

    public static boolean partitionMatchesPredicates(SchemaTableName tableName, String hivePartitionName, List<HiveColumnHandle> partitionColumnHandles, TupleDomain<HiveColumnHandle> constraintSummary) {
        List partitionColumnTypes = partitionColumnHandles.stream().map(HiveColumnHandle::getType).collect(Collectors.toList());
        HivePartition partition = HivePartitionManager.parsePartition((SchemaTableName)tableName, (String)hivePartitionName, partitionColumnHandles, partitionColumnTypes);
        return HudiUtil.partitionMatches(partitionColumnHandles, constraintSummary, partition);
    }

    public static boolean partitionMatchesPredicates(SchemaTableName tableName, String relativePartitionPath, List<String> partitionValues, List<HiveColumnHandle> partitionColumnHandles, TupleDomain<HiveColumnHandle> constraintSummary) {
        List<Type> partitionColumnTypes = partitionColumnHandles.stream().map(HiveColumnHandle::getType).collect(Collectors.toList());
        HivePartition partition = HudiUtil.parsePartition(tableName, relativePartitionPath, partitionValues, partitionColumnHandles, partitionColumnTypes);
        return HudiUtil.partitionMatches(partitionColumnHandles, constraintSummary, partition);
    }

    private static HivePartition parsePartition(SchemaTableName tableName, String partitionName, List<String> partitionValues, List<HiveColumnHandle> partitionColumns, List<Type> partitionColumnTypes) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            HiveColumnHandle column = partitionColumns.get(i);
            NullableValue parsedValue = HiveUtil.parsePartitionValue((String)partitionName, (String)partitionValues.get(i), (Type)partitionColumnTypes.get(i));
            builder.put((Object)column, (Object)parsedValue);
        }
        ImmutableMap values = builder.buildOrThrow();
        return new HivePartition(tableName, partitionName, (Map)values);
    }

    public static boolean partitionMatches(List<HiveColumnHandle> partitionColumns, TupleDomain<HiveColumnHandle> constraintSummary, HivePartition partition) {
        if (constraintSummary.isNone()) {
            return false;
        }
        Map domains = constraintSummary.getDomains().orElseGet(ImmutableMap::of);
        for (HiveColumnHandle column : partitionColumns) {
            NullableValue value = (NullableValue)partition.getKeys().get(column);
            Domain allowedDomain = (Domain)domains.get(column);
            if (allowedDomain == null || allowedDomain.includesNullableValue(value.getValue())) continue;
            return false;
        }
        return true;
    }

    public static List<HivePartitionKey> buildPartitionKeys(List<Column> keys, List<String> values) {
        HiveUtil.checkCondition((keys.size() == values.size() ? 1 : 0) != 0, (ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, (String)"Expected %s partition key values, but got %s. Keys: %s, Values: %s.", (Object[])new Object[]{keys.size(), values.size(), keys, values});
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        for (int i = 0; i < keys.size(); ++i) {
            String name = keys.get(i).getName();
            String value = values.get(i);
            partitionKeys.add((Object)new HivePartitionKey(name, value));
        }
        return partitionKeys.build();
    }

    public static HoodieTableMetaClient buildTableMetaClient(Configuration configuration, String basePath) {
        HoodieTableMetaClient client = HoodieTableMetaClient.builder().setConf(configuration).setBasePath(basePath).build();
        client.getTableConfig().setValue("hoodie.bootstrap.index.enable", "false");
        return client;
    }

    public static FileStatus getFileStatus(HoodieBaseFile baseFile) {
        try {
            return HoodieInputFormatUtils.getFileStatus((HoodieBaseFile)baseFile);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_CANNOT_OPEN_SPLIT, "Error getting file status of " + baseFile.getPath(), (Throwable)e);
        }
    }
}

