/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.event.client.EventModule;
import io.airlift.json.JsonModule;
import io.trino.filesystem.hdfs.HdfsFileSystemModule;
import io.trino.hdfs.HdfsModule;
import io.trino.hdfs.authentication.HdfsAuthenticationModule;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitManager;
import io.trino.plugin.base.classloader.ClassLoaderSafeNodePartitioningProvider;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.hive.azure.HiveAzureModule;
import io.trino.plugin.hive.gcs.HiveGcsModule;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreModule;
import io.trino.plugin.hive.s3.HiveS3Module;
import io.trino.plugin.hudi.HudiConnector;
import io.trino.plugin.hudi.HudiModule;
import io.trino.plugin.hudi.HudiTableProperties;
import io.trino.plugin.hudi.HudiTransactionManager;
import io.trino.spi.NodeManager;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.weakref.jmx.guice.MBeanModule;

public class InternalHudiConnectorFactory {
    private InternalHudiConnectorFactory() {
    }

    public static Connector createConnector(String catalogName, Map<String, String> config, ConnectorContext context, Optional<HiveMetastore> metastore) {
        ClassLoader classLoader = InternalHudiConnectorFactory.class.getClassLoader();
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new EventModule(), new MBeanModule(), new JsonModule(), new HudiModule(), new HiveMetastoreModule(metastore), new HdfsModule(), new HiveS3Module(), new HiveGcsModule(), new HiveAzureModule(), new HdfsAuthenticationModule(), new HdfsFileSystemModule(), new MBeanServerModule(), binder -> {
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(CatalogName.class).toInstance((Object)new CatalogName(catalogName));
            }});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            HudiTransactionManager transactionManager = (HudiTransactionManager)injector.getInstance(HudiTransactionManager.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorPageSourceProvider connectorPageSource = (ConnectorPageSourceProvider)injector.getInstance(ConnectorPageSourceProvider.class);
            ConnectorNodePartitioningProvider connectorDistributionProvider = (ConnectorNodePartitioningProvider)injector.getInstance(ConnectorNodePartitioningProvider.class);
            Set sessionPropertiesProviders = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<SessionPropertiesProvider>>(){}));
            HudiTableProperties hudiTableProperties = (HudiTableProperties)injector.getInstance(HudiTableProperties.class);
            HudiConnector hudiConnector = new HudiConnector(lifeCycleManager, transactionManager, (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, classLoader), (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSource, classLoader), (ConnectorNodePartitioningProvider)new ClassLoaderSafeNodePartitioningProvider(connectorDistributionProvider, classLoader), (Set<SystemTable>)ImmutableSet.of(), sessionPropertiesProviders, hudiTableProperties.getTableProperties());
            return hudiConnector;
        }
    }
}

