/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.partition;

import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hudi.HudiSessionProperties;
import io.trino.plugin.hudi.partition.HiveHudiPartitionInfo;
import io.trino.plugin.hudi.partition.HudiPartitionInfo;
import io.trino.plugin.hudi.query.HudiDirectoryLister;
import io.trino.spi.connector.ConnectorSession;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import org.apache.hudi.exception.HoodieIOException;

public class HudiPartitionInfoLoader
implements Runnable {
    private final HudiDirectoryLister hudiDirectoryLister;
    private final int minPartitionBatchSize;
    private final int maxPartitionBatchSize;
    private final Deque<HudiPartitionInfo> partitionQueue;
    private int currentBatchSize;

    public HudiPartitionInfoLoader(ConnectorSession session, HudiDirectoryLister hudiDirectoryLister) {
        this.hudiDirectoryLister = hudiDirectoryLister;
        this.partitionQueue = new ConcurrentLinkedDeque<HudiPartitionInfo>();
        this.minPartitionBatchSize = HudiSessionProperties.getMinPartitionBatchSize(session);
        this.maxPartitionBatchSize = HudiSessionProperties.getMaxPartitionBatchSize(session);
        this.currentBatchSize = -1;
    }

    @Override
    public void run() {
        List hudiPartitionInfoList = this.hudiDirectoryLister.getPartitionsToScan().stream().sorted(Comparator.comparing(HudiPartitionInfo::getComparingKey)).collect(Collectors.toList());
        if (hudiPartitionInfoList.isEmpty()) {
            return;
        }
        if (hudiPartitionInfoList.size() == 1 && ((HudiPartitionInfo)hudiPartitionInfoList.get(0)).getHivePartitionName().isEmpty()) {
            this.partitionQueue.addAll(hudiPartitionInfoList);
            return;
        }
        boolean shouldUseHiveMetastore = hudiPartitionInfoList.get(0) instanceof HiveHudiPartitionInfo;
        Iterator iterator = hudiPartitionInfoList.iterator();
        while (iterator.hasNext()) {
            ArrayList<HudiPartitionInfo> partitionInfoBatch = new ArrayList<HudiPartitionInfo>();
            for (int batchSize = this.updateBatchSize(); iterator.hasNext() && batchSize > 0; --batchSize) {
                partitionInfoBatch.add((HudiPartitionInfo)iterator.next());
            }
            if (partitionInfoBatch.isEmpty()) continue;
            if (shouldUseHiveMetastore) {
                Map<String, Optional<Partition>> partitions = this.hudiDirectoryLister.getPartitions(partitionInfoBatch.stream().map(HudiPartitionInfo::getHivePartitionName).collect(Collectors.toList()));
                for (HudiPartitionInfo partitionInfo : partitionInfoBatch) {
                    String hivePartitionName = partitionInfo.getHivePartitionName();
                    if (!partitions.containsKey(hivePartitionName)) {
                        throw new HoodieIOException("Partition does not exist: " + hivePartitionName);
                    }
                    partitionInfo.loadPartitionInfo(partitions.get(hivePartitionName));
                    this.partitionQueue.add(partitionInfo);
                }
                continue;
            }
            for (HudiPartitionInfo partitionInfo : partitionInfoBatch) {
                partitionInfo.getHivePartitionKeys();
                this.partitionQueue.add(partitionInfo);
            }
        }
    }

    public Deque<HudiPartitionInfo> getPartitionQueue() {
        return this.partitionQueue;
    }

    private int updateBatchSize() {
        if (this.currentBatchSize <= 0) {
            this.currentBatchSize = this.minPartitionBatchSize;
        } else {
            this.currentBatchSize *= 2;
            this.currentBatchSize = Math.min(this.currentBatchSize, this.maxPartitionBatchSize);
        }
        return this.currentBatchSize;
    }
}

