/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.query;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.plugin.hudi.HudiUtil;
import io.trino.plugin.hudi.partition.HiveHudiPartitionInfo;
import io.trino.plugin.hudi.partition.HudiPartitionInfo;
import io.trino.plugin.hudi.query.HudiDirectoryLister;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;

public class HudiReadOptimizedDirectoryLister
implements HudiDirectoryLister {
    private final HudiTableHandle tableHandle;
    private final HiveMetastore hiveMetastore;
    private final Table hiveTable;
    private final SchemaTableName tableName;
    private final List<HiveColumnHandle> partitionColumnHandles;
    private final HoodieTableFileSystemView fileSystemView;
    private final TupleDomain<String> partitionKeysFilter;
    private final List<Column> partitionColumns;
    private List<String> hivePartitionNames;

    public HudiReadOptimizedDirectoryLister(HoodieMetadataConfig metadataConfig, HoodieEngineContext engineContext, HudiTableHandle tableHandle, HoodieTableMetaClient metaClient, HiveMetastore hiveMetastore, Table hiveTable, List<HiveColumnHandle> partitionColumnHandles) {
        this.tableHandle = tableHandle;
        this.tableName = tableHandle.getSchemaTableName();
        this.hiveMetastore = hiveMetastore;
        this.hiveTable = hiveTable;
        this.partitionColumnHandles = partitionColumnHandles;
        this.fileSystemView = FileSystemViewManager.createInMemoryFileSystemView((HoodieEngineContext)engineContext, (HoodieTableMetaClient)metaClient, (HoodieMetadataConfig)metadataConfig);
        this.partitionKeysFilter = MetastoreUtil.computePartitionKeyFilter(partitionColumnHandles, tableHandle.getPartitionPredicates());
        this.partitionColumns = hiveTable.getPartitionColumns();
    }

    @Override
    public List<HudiPartitionInfo> getPartitionsToScan() {
        if (this.hivePartitionNames == null) {
            this.hivePartitionNames = this.partitionColumns.isEmpty() ? Collections.singletonList("") : this.getPartitionNamesFromHiveMetastore(this.partitionKeysFilter);
        }
        List allPartitionInfoList = this.hivePartitionNames.stream().map(hivePartitionName -> new HiveHudiPartitionInfo((String)hivePartitionName, this.partitionColumns, this.partitionColumnHandles, this.tableHandle.getPartitionPredicates(), this.hiveTable, this.hiveMetastore)).collect(Collectors.toList());
        return allPartitionInfoList.stream().filter(partitionInfo -> partitionInfo.getHivePartitionKeys().isEmpty() || partitionInfo.doesMatchPredicates()).collect(Collectors.toList());
    }

    @Override
    public List<FileStatus> listStatus(HudiPartitionInfo partitionInfo) {
        return (List)this.fileSystemView.getLatestBaseFiles(partitionInfo.getRelativePartitionPath()).map(baseFile -> HudiUtil.getFileStatus(baseFile)).collect(ImmutableList.toImmutableList());
    }

    private List<String> getPartitionNamesFromHiveMetastore(TupleDomain<String> partitionKeysFilter) {
        return (List)this.hiveMetastore.getPartitionNamesByFilter(this.tableName.getSchemaName(), this.tableName.getTableName(), this.partitionColumns.stream().map(Column::getName).collect(Collectors.toList()), partitionKeysFilter).orElseThrow(() -> new TableNotFoundException(this.tableHandle.getSchemaTableName()));
    }

    @Override
    public Map<String, Optional<Partition>> getPartitions(List<String> partitionNames) {
        return this.hiveMetastore.getPartitionsByNames(this.hiveTable, partitionNames);
    }

    @Override
    public void close() {
        if (this.fileSystemView != null && !this.fileSystemView.isClosed()) {
            this.fileSystemView.close();
        }
    }
}

