/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.log.Logger;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.plugin.hudi.HudiErrorCode;
import io.trino.plugin.hudi.compaction.CompactionOperation;
import io.trino.plugin.hudi.compaction.HudiCompactionOperation;
import io.trino.plugin.hudi.compaction.HudiCompactionPlan;
import io.trino.plugin.hudi.files.FSUtils;
import io.trino.plugin.hudi.files.HudiBaseFile;
import io.trino.plugin.hudi.files.HudiFileGroup;
import io.trino.plugin.hudi.files.HudiFileGroupId;
import io.trino.plugin.hudi.files.HudiLogFile;
import io.trino.plugin.hudi.model.HudiFileFormat;
import io.trino.plugin.hudi.model.HudiInstant;
import io.trino.plugin.hudi.model.HudiReplaceCommitMetadata;
import io.trino.plugin.hudi.table.HudiTableMetaClient;
import io.trino.plugin.hudi.timeline.HudiTimeline;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecordBase;

public class HudiTableFileSystemView {
    private static final Logger LOG = Logger.get(HudiTableFileSystemView.class);
    private static final Integer VERSION_2 = 2;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private final ReentrantReadWriteLock globalLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.globalLock.readLock();
    private final ConcurrentHashMap<String, Boolean> addedPartitions = new ConcurrentHashMap(4096);
    private boolean closed;
    private Map<String, List<HudiFileGroup>> partitionToFileGroupsMap = new ConcurrentHashMap<String, List<HudiFileGroup>>();
    private HudiTableMetaClient metaClient;
    private Map<HudiFileGroupId, Map.Entry<String, CompactionOperation>> fgIdToPendingCompaction;
    private HudiTimeline visibleCommitsAndCompactionTimeline;
    private Map<HudiFileGroupId, HudiInstant> fgIdToReplaceInstants;

    public HudiTableFileSystemView(HudiTableMetaClient metaClient, HudiTimeline visibleActiveTimeline) {
        this.metaClient = metaClient;
        this.visibleCommitsAndCompactionTimeline = visibleActiveTimeline.getWriteTimeline();
        this.resetFileGroupsReplaced(this.visibleCommitsAndCompactionTimeline);
        this.resetPendingCompactionOperations(HudiTableFileSystemView.getAllPendingCompactionOperations(metaClient).values().stream().map(pair -> Map.entry((String)pair.getKey(), CompactionOperation.convertFromAvroRecordInstance((HudiCompactionOperation)((Object)((Object)pair.getValue()))))));
    }

    private static Map<HudiFileGroupId, Map.Entry<String, HudiCompactionOperation>> getAllPendingCompactionOperations(HudiTableMetaClient metaClient) {
        List<Map.Entry<HudiInstant, HudiCompactionPlan>> pendingCompactionPlanWithInstants = HudiTableFileSystemView.getAllPendingCompactionPlans(metaClient);
        HashMap<HudiFileGroupId, Map.Entry<String, HudiCompactionOperation>> fgIdToPendingCompactionWithInstantMap = new HashMap<HudiFileGroupId, Map.Entry<String, HudiCompactionOperation>>();
        pendingCompactionPlanWithInstants.stream().flatMap(instantPlanPair -> HudiTableFileSystemView.getPendingCompactionOperations((HudiInstant)instantPlanPair.getKey(), (HudiCompactionPlan)((Object)((Object)instantPlanPair.getValue())))).forEach(pair -> {
            HudiCompactionOperation anotherOperation;
            HudiCompactionOperation operation;
            if (fgIdToPendingCompactionWithInstantMap.containsKey(pair.getKey()) && !(operation = (HudiCompactionOperation)((Object)((Object)((Map.Entry)pair.getValue()).getValue()))).equals((Object)(anotherOperation = (HudiCompactionOperation)((Object)((Object)((Map.Entry)fgIdToPendingCompactionWithInstantMap.get(pair.getKey())).getValue()))))) {
                String msg = "Hudi File Id (" + pair.getKey() + ") has more than 1 pending compactions. Instants: " + pair.getValue() + ", " + fgIdToPendingCompactionWithInstantMap.get(pair.getKey());
                throw new IllegalStateException(msg);
            }
            fgIdToPendingCompactionWithInstantMap.put((HudiFileGroupId)pair.getKey(), (Map.Entry)pair.getValue());
        });
        return fgIdToPendingCompactionWithInstantMap;
    }

    private static List<Map.Entry<HudiInstant, HudiCompactionPlan>> getAllPendingCompactionPlans(HudiTableMetaClient metaClient) {
        List pendingCompactionInstants = (List)metaClient.getActiveTimeline().filterPendingCompactionTimeline().getInstants().collect(ImmutableList.toImmutableList());
        return (List)pendingCompactionInstants.stream().map(instant -> {
            try {
                return Map.entry(instant, HudiTableFileSystemView.getCompactionPlan(metaClient, instant.getTimestamp()));
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_BAD_DATA, (Throwable)e);
            }
        }).collect(ImmutableList.toImmutableList());
    }

    private static HudiCompactionPlan getCompactionPlan(HudiTableMetaClient metaClient, String compactionInstant) throws IOException {
        HudiCompactionPlan compactionPlan = HudiTableFileSystemView.deserializeAvroMetadata(metaClient.getActiveTimeline().readCompactionPlanAsBytes(HudiTimeline.getCompactionRequestedInstant(compactionInstant)).get(), HudiCompactionPlan.class);
        return HudiTableFileSystemView.upgradeToLatest(compactionPlan, compactionPlan.getVersion());
    }

    private static HudiCompactionPlan upgradeToLatest(HudiCompactionPlan metadata, int metadataVersion) {
        if (metadataVersion == VERSION_2) {
            return metadata;
        }
        Preconditions.checkState((metadataVersion == 1 ? 1 : 0) != 0, (Object)"Lowest supported metadata version is 1");
        List<HudiCompactionOperation> v2CompactionOperationList = new ArrayList<HudiCompactionOperation>();
        if (null != metadata.getOperations()) {
            v2CompactionOperationList = (List)metadata.getOperations().stream().map(compactionOperation -> HudiCompactionOperation.newBuilder().setBaseInstantTime(compactionOperation.getBaseInstantTime()).setFileId(compactionOperation.getFileId()).setPartitionPath(compactionOperation.getPartitionPath()).setMetrics(compactionOperation.getMetrics()).setDataFilePath(compactionOperation.getDataFilePath() == null ? null : Location.of((String)compactionOperation.getDataFilePath()).fileName()).setDeltaFilePaths((List)compactionOperation.getDeltaFilePaths().stream().map(filePath -> Location.of((String)filePath).fileName()).collect(ImmutableList.toImmutableList())).build()).collect(ImmutableList.toImmutableList());
        }
        return new HudiCompactionPlan(v2CompactionOperationList, metadata.getExtraMetadata(), VERSION_2);
    }

    private static <T extends SpecificRecordBase> T deserializeAvroMetadata(byte[] bytes, Class<T> clazz) throws IOException {
        SpecificDatumReader reader = new SpecificDatumReader(clazz);
        FileReader fileReader = DataFileReader.openReader((SeekableInput)new SeekableByteArrayInput(bytes), (DatumReader)reader);
        Preconditions.checkState((boolean)fileReader.hasNext(), (Object)("Could not deserialize metadata of type " + clazz));
        return (T)((SpecificRecordBase)fileReader.next());
    }

    private static Stream<Map.Entry<HudiFileGroupId, Map.Entry<String, HudiCompactionOperation>>> getPendingCompactionOperations(HudiInstant instant, HudiCompactionPlan compactionPlan) {
        List<HudiCompactionOperation> ops = compactionPlan.getOperations();
        if (null != ops) {
            return ops.stream().map(op -> Map.entry(new HudiFileGroupId(op.getPartitionPath(), op.getFileId()), Map.entry(instant.getTimestamp(), op)));
        }
        return Stream.empty();
    }

    private void resetPendingCompactionOperations(Stream<Map.Entry<String, CompactionOperation>> operations) {
        this.fgIdToPendingCompaction = (Map)operations.collect(ImmutableMap.toImmutableMap(entry -> ((CompactionOperation)entry.getValue()).getFileGroupId(), Function.identity()));
    }

    private void resetFileGroupsReplaced(HudiTimeline timeline) {
        HudiTimeline replacedTimeline = timeline.getCompletedReplaceTimeline();
        Map replacedFileGroups = (Map)replacedTimeline.getInstants().flatMap(instant -> {
            try {
                HudiReplaceCommitMetadata replaceMetadata = HudiReplaceCommitMetadata.fromBytes(this.metaClient.getActiveTimeline().getInstantDetails((HudiInstant)instant).get(), OBJECT_MAPPER, HudiReplaceCommitMetadata.class);
                return replaceMetadata.getPartitionToReplaceFileIds().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(fileId -> Map.entry(new HudiFileGroupId((String)entry.getKey(), (String)fileId), instant)));
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_BAD_DATA, "error reading commit metadata for " + instant, (Throwable)e);
            }
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        this.fgIdToReplaceInstants = new ConcurrentHashMap<HudiFileGroupId, HudiInstant>(replacedFileGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Stream<HudiBaseFile> getLatestBaseFiles(String partitionStr) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<HudiBaseFile> stream = this.fetchLatestBaseFiles(partitionPath).filter(hudiBaseFile -> !this.isFileGroupReplaced(partitionPath, hudiBaseFile.getFileId()));
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isFileGroupReplaced(String partitionPath, String fileId) {
        return this.isFileGroupReplaced(new HudiFileGroupId(partitionPath, fileId));
    }

    private String formatPartitionKey(String partitionStr) {
        return partitionStr.endsWith("/") ? partitionStr.substring(0, partitionStr.length() - 1) : partitionStr;
    }

    private void ensurePartitionLoadedCorrectly(String partition) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"View is already closed");
        this.addedPartitions.computeIfAbsent(partition, this::lambda$ensurePartitionLoadedCorrectly$12);
    }

    protected boolean isPartitionAvailableInStore(String partitionPath) {
        return this.partitionToFileGroupsMap.containsKey(partitionPath);
    }

    private FileIterator listPartition(Location partitionLocation) throws IOException {
        FileIterator fileIterator = this.metaClient.getFileSystem().listFiles(partitionLocation);
        if (fileIterator.hasNext()) {
            return fileIterator;
        }
        try (OutputStream ignored = this.metaClient.getFileSystem().newOutputFile(partitionLocation).create();){
            FileIterator fileIterator2 = FileIterator.empty();
            return fileIterator2;
        }
    }

    public List<HudiFileGroup> addFilesToView(FileIterator partitionFiles) throws IOException {
        List<HudiFileGroup> fileGroups = this.buildFileGroups(partitionFiles, this.visibleCommitsAndCompactionTimeline, true);
        fileGroups.stream().collect(Collectors.groupingBy(HudiFileGroup::getPartitionPath)).forEach((partition, value) -> {
            if (!this.isPartitionAvailableInStore((String)partition)) {
                this.storePartitionView((String)partition, (List<HudiFileGroup>)value);
            }
        });
        return fileGroups;
    }

    private List<HudiFileGroup> buildFileGroups(FileIterator partitionFiles, HudiTimeline timeline, boolean addPendingCompactionFileSlice) throws IOException {
        ArrayList<HudiBaseFile> hoodieBaseFiles = new ArrayList<HudiBaseFile>();
        ArrayList<HudiLogFile> hudiLogFiles = new ArrayList<HudiLogFile>();
        String baseHoodieFileExtension = this.metaClient.getTableConfig().getBaseFileFormat().getFileExtension();
        while (partitionFiles.hasNext()) {
            String fileName;
            FileEntry fileEntry = partitionFiles.next();
            if (fileEntry.location().path().contains(baseHoodieFileExtension)) {
                hoodieBaseFiles.add(new HudiBaseFile(fileEntry));
            }
            if (!FSUtils.LOG_FILE_PATTERN.matcher(fileName = fileEntry.location().fileName()).matches() || !fileName.contains(HudiFileFormat.HOODIE_LOG.getFileExtension())) continue;
            hudiLogFiles.add(new HudiLogFile(fileEntry));
        }
        return this.buildFileGroups(hoodieBaseFiles.stream(), hudiLogFiles.stream(), timeline, addPendingCompactionFileSlice);
    }

    private List<HudiFileGroup> buildFileGroups(Stream<HudiBaseFile> baseFileStream, Stream<HudiLogFile> logFileStream, HudiTimeline timeline, boolean addPendingCompactionFileSlice) {
        Map<Map.Entry, List<HudiBaseFile>> baseFiles = baseFileStream.collect(Collectors.groupingBy(baseFile -> {
            String partitionPathStr = this.getPartitionPathFor((HudiBaseFile)baseFile);
            return Map.entry(partitionPathStr, baseFile.getFileId());
        }));
        Map<Map.Entry, List<HudiLogFile>> logFiles = logFileStream.collect(Collectors.groupingBy(logFile -> {
            String partitionPathStr = this.getRelativePartitionPath(this.metaClient.getBasePath(), logFile.getPath().parentDirectory());
            return Map.entry(partitionPathStr, logFile.getFileId());
        }));
        HashSet<Map.Entry> fileIdSet = new HashSet<Map.Entry>(baseFiles.keySet());
        fileIdSet.addAll(logFiles.keySet());
        ArrayList<HudiFileGroup> fileGroups = new ArrayList<HudiFileGroup>();
        fileIdSet.forEach(pair -> {
            String fileId = (String)pair.getValue();
            String partitionPath = (String)pair.getKey();
            HudiFileGroup group = new HudiFileGroup(partitionPath, fileId, timeline);
            if (baseFiles.containsKey(pair)) {
                ((List)baseFiles.get(pair)).forEach(group::addBaseFile);
            }
            if (logFiles.containsKey(pair)) {
                ((List)logFiles.get(pair)).forEach(group::addLogFile);
            }
            if (addPendingCompactionFileSlice) {
                Optional<Map.Entry<String, CompactionOperation>> pendingCompaction = this.getPendingCompactionOperationWithInstant(group.getFileGroupId());
                pendingCompaction.ifPresent(entry -> group.addNewFileSliceAtInstant((String)entry.getKey()));
            }
            fileGroups.add(group);
        });
        return fileGroups;
    }

    private String getPartitionPathFor(HudiBaseFile baseFile) {
        return this.getRelativePartitionPath(this.metaClient.getBasePath(), baseFile.getFullPath().parentDirectory());
    }

    private String getRelativePartitionPath(Location basePath, Location fullPartitionPath) {
        String fullPartitionPathStr = fullPartitionPath.path();
        if (!fullPartitionPathStr.startsWith(basePath.path())) {
            throw new IllegalArgumentException("Partition location does not belong to base-location");
        }
        int partitionStartIndex = fullPartitionPath.path().indexOf(basePath.fileName(), basePath.parentDirectory().path().length());
        if (partitionStartIndex + basePath.fileName().length() == fullPartitionPathStr.length()) {
            return "";
        }
        return fullPartitionPathStr.substring(partitionStartIndex + basePath.fileName().length() + 1);
    }

    protected Optional<Map.Entry<String, CompactionOperation>> getPendingCompactionOperationWithInstant(HudiFileGroupId fgId) {
        return Optional.ofNullable(this.fgIdToPendingCompaction.get(fgId));
    }

    private void storePartitionView(String partitionPath, List<HudiFileGroup> fileGroups) {
        LOG.debug("Adding file-groups for partition :" + partitionPath + ", #FileGroups=" + fileGroups.size());
        ImmutableList newList = ImmutableList.copyOf(fileGroups);
        this.partitionToFileGroupsMap.put(partitionPath, (List<HudiFileGroup>)newList);
    }

    private Stream<HudiBaseFile> fetchLatestBaseFiles(String partitionPath) {
        return this.fetchAllStoredFileGroups(partitionPath).filter(filGroup -> !this.isFileGroupReplaced(filGroup.getFileGroupId())).map(filGroup -> Map.entry(filGroup.getFileGroupId(), this.getLatestBaseFile((HudiFileGroup)filGroup))).filter(pair -> ((Optional)pair.getValue()).isPresent()).map(pair -> (HudiBaseFile)((Optional)pair.getValue()).get());
    }

    private Stream<HudiFileGroup> fetchAllStoredFileGroups(String partition) {
        ImmutableList fileGroups = ImmutableList.copyOf((Collection)this.partitionToFileGroupsMap.get(partition));
        return fileGroups.stream();
    }

    private boolean isFileGroupReplaced(HudiFileGroupId fileGroup) {
        return Optional.ofNullable(this.fgIdToReplaceInstants.get(fileGroup)).isPresent();
    }

    protected Optional<HudiBaseFile> getLatestBaseFile(HudiFileGroup fileGroup) {
        return fileGroup.getAllBaseFiles().filter(hudiBaseFile -> !this.isBaseFileDueToPendingCompaction((HudiBaseFile)hudiBaseFile) && !this.isBaseFileDueToPendingClustering((HudiBaseFile)hudiBaseFile)).findFirst();
    }

    private boolean isBaseFileDueToPendingCompaction(HudiBaseFile baseFile) {
        String partitionPath = this.getPartitionPathFor(baseFile);
        Optional<Map.Entry<String, CompactionOperation>> compactionWithInstantTime = this.getPendingCompactionOperationWithInstant(new HudiFileGroupId(partitionPath, baseFile.getFileId()));
        return compactionWithInstantTime.isPresent() && null != compactionWithInstantTime.get().getKey() && baseFile.getCommitTime().equals(compactionWithInstantTime.get().getKey());
    }

    private boolean isBaseFileDueToPendingClustering(HudiBaseFile baseFile) {
        List pendingReplaceInstants = (List)this.metaClient.getActiveTimeline().filterPendingReplaceTimeline().getInstants().map(HudiInstant::getTimestamp).collect(ImmutableList.toImmutableList());
        return !pendingReplaceInstants.isEmpty() && pendingReplaceInstants.contains(baseFile.getCommitTime());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.fgIdToPendingCompaction = null;
        this.partitionToFileGroupsMap = null;
        this.fgIdToReplaceInstants = null;
        this.closed = true;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ Boolean lambda$ensurePartitionLoadedCorrectly$12(String partitionPathStr) {
        beginTs = System.currentTimeMillis();
        if (!this.isPartitionAvailableInStore(partitionPathStr)) {
            try {
                HudiTableFileSystemView.LOG.info("Building file system view for partition (" + partitionPathStr + ")");
                partitionLocation = FSUtils.getPartitionLocation(this.metaClient.getBasePath(), partitionPathStr);
                partitionFiles = this.listPartition(partitionLocation);
                groups = this.addFilesToView(partitionFiles);
                if (!groups.isEmpty()) ** GOTO lbl14
                this.storePartitionView(partitionPathStr, new ArrayList<HudiFileGroup>());
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_BAD_DATA, "Failed to list base files in partition " + partitionPathStr, (Throwable)e);
            }
        } else {
            HudiTableFileSystemView.LOG.debug("View already built for Partition :" + partitionPathStr + ", FOUND is ");
        }
lbl14:
        // 3 sources

        endTs = System.currentTimeMillis();
        HudiTableFileSystemView.LOG.debug("Time to load partition (" + partitionPathStr + ") =" + (endTs - beginTs));
        return true;
    }
}

