/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Locale;

@DefunctConfig(value={"hudi.min-partition-batch-size", "hudi.max-partition-batch-size", "hudi.metadata-enabled"})
public class HudiConfig {
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private List<String> columnsToHide = ImmutableList.of();
    private boolean shouldUseParquetColumnNames = true;
    private boolean sizeBasedSplitWeightsEnabled = true;
    private DataSize standardSplitWeightSize = DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private double minimumAssignedSplitWeight = 0.05;
    private int maxSplitsPerSecond = Integer.MAX_VALUE;
    private int maxOutstandingSplits = 1000;
    private int splitLoaderParallelism = 4;
    private int splitGeneratorParallelism = 4;
    private long perTransactionMetastoreCacheMaximumSize = 2000L;

    public List<String> getColumnsToHide() {
        return this.columnsToHide;
    }

    @Config(value="hudi.columns-to-hide")
    @ConfigDescription(value="List of column names that will be hidden from the query output. It can be used to hide Hudi meta fields. By default, no fields are hidden.")
    public HudiConfig setColumnsToHide(String columnsToHide) {
        this.columnsToHide = (List)COMMA_SPLITTER.splitToStream((CharSequence)Strings.nullToEmpty((String)columnsToHide)).map(s -> s.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
        return this;
    }

    @Config(value="hudi.parquet.use-column-names")
    @ConfigDescription(value="Access Parquet columns using names from the file. If disabled, then columns are accessed using index.Only applicable to Parquet file format.")
    public HudiConfig setUseParquetColumnNames(boolean shouldUseParquetColumnNames) {
        this.shouldUseParquetColumnNames = shouldUseParquetColumnNames;
        return this;
    }

    public boolean getUseParquetColumnNames() {
        return this.shouldUseParquetColumnNames;
    }

    @Config(value="hudi.size-based-split-weights-enabled")
    @ConfigDescription(value="Unlike uniform splitting, size-based splitting ensures that each batch of splits has enough data to process. By default, it is enabled to improve performance.")
    public HudiConfig setSizeBasedSplitWeightsEnabled(boolean sizeBasedSplitWeightsEnabled) {
        this.sizeBasedSplitWeightsEnabled = sizeBasedSplitWeightsEnabled;
        return this;
    }

    public boolean isSizeBasedSplitWeightsEnabled() {
        return this.sizeBasedSplitWeightsEnabled;
    }

    @Config(value="hudi.standard-split-weight-size")
    @ConfigDescription(value="The split size corresponding to the standard weight (1.0) when size based split weights are enabled.")
    public HudiConfig setStandardSplitWeightSize(DataSize standardSplitWeightSize) {
        this.standardSplitWeightSize = standardSplitWeightSize;
        return this;
    }

    @NotNull
    public DataSize getStandardSplitWeightSize() {
        return this.standardSplitWeightSize;
    }

    @Config(value="hudi.minimum-assigned-split-weight")
    @ConfigDescription(value="Minimum weight that a split can be assigned when size based split weights are enabled.")
    public HudiConfig setMinimumAssignedSplitWeight(double minimumAssignedSplitWeight) {
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        return this;
    }

    @DecimalMax(value="1")
    @DecimalMin(value="0", inclusive=false)
    public @DecimalMax(value="1") @DecimalMin(value="0", inclusive=false) double getMinimumAssignedSplitWeight() {
        return this.minimumAssignedSplitWeight;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxSplitsPerSecond() {
        return this.maxSplitsPerSecond;
    }

    @Config(value="hudi.max-splits-per-second")
    @ConfigDescription(value="Rate at which splits are enqueued for processing. The queue will throttle if this rate limit is breached.")
    public HudiConfig setMaxSplitsPerSecond(int maxSplitsPerSecond) {
        this.maxSplitsPerSecond = maxSplitsPerSecond;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxOutstandingSplits() {
        return this.maxOutstandingSplits;
    }

    @Config(value="hudi.max-outstanding-splits")
    @ConfigDescription(value="Maximum outstanding splits in a batch enqueued for processing.")
    public HudiConfig setMaxOutstandingSplits(int maxOutstandingSplits) {
        this.maxOutstandingSplits = maxOutstandingSplits;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSplitGeneratorParallelism() {
        return this.splitGeneratorParallelism;
    }

    @Config(value="hudi.split-generator-parallelism")
    @ConfigDescription(value="Number of threads to generate splits from partitions.")
    public HudiConfig setSplitGeneratorParallelism(int splitGeneratorParallelism) {
        this.splitGeneratorParallelism = splitGeneratorParallelism;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSplitLoaderParallelism() {
        return this.splitLoaderParallelism;
    }

    @Config(value="hudi.split-loader-parallelism")
    @ConfigDescription(value="Number of threads to run background split loader. A single background split loader is needed per query.")
    public HudiConfig setSplitLoaderParallelism(int splitLoaderParallelism) {
        this.splitLoaderParallelism = splitLoaderParallelism;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) long getPerTransactionMetastoreCacheMaximumSize() {
        return this.perTransactionMetastoreCacheMaximumSize;
    }

    @Config(value="hudi.per-transaction-metastore-cache-maximum-size")
    public HudiConfig setPerTransactionMetastoreCacheMaximumSize(long perTransactionMetastoreCacheMaximumSize) {
        this.perTransactionMetastoreCacheMaximumSize = perTransactionMetastoreCacheMaximumSize;
        return this;
    }
}

