/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hudi.HudiConfig;
import io.trino.plugin.hudi.HudiMetadata;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;

public class HudiMetadataFactory {
    private final HiveMetastoreFactory metastoreFactory;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TypeManager typeManager;
    private final long perTransactionMetastoreCacheMaximumSize;

    @Inject
    public HudiMetadataFactory(HiveMetastoreFactory metastoreFactory, TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager, HudiConfig hudiConfig) {
        this.metastoreFactory = Objects.requireNonNull(metastoreFactory, "metastore is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.perTransactionMetastoreCacheMaximumSize = hudiConfig.getPerTransactionMetastoreCacheMaximumSize();
    }

    public HudiMetadata create(ConnectorIdentity identity) {
        CachingHiveMetastore cachingHiveMetastore = CachingHiveMetastore.memoizeMetastore((HiveMetastore)this.metastoreFactory.createMetastore(Optional.of(identity)), (long)this.perTransactionMetastoreCacheMaximumSize);
        return new HudiMetadata((HiveMetastore)cachingHiveMetastore, this.fileSystemFactory, this.typeManager);
    }
}

