/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.config;

import com.google.common.base.Preconditions;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.plugin.hudi.HudiErrorCode;
import io.trino.plugin.hudi.model.HudiFileFormat;
import io.trino.plugin.hudi.model.HudiTableType;
import io.trino.plugin.hudi.timeline.TimelineLayoutVersion;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;

public class HudiTableConfig {
    public static final String HOODIE_PROPERTIES_FILE = "hoodie.properties";
    public static final String HOODIE_PROPERTIES_FILE_BACKUP = "hoodie.properties.backup";
    public static final String HOODIE_TABLE_NAME_KEY = "hoodie.table.name";
    public static final String HOODIE_TABLE_TYPE_KEY = "hoodie.table.type";
    public static final String HOODIE_TABLE_BASE_FILE_FORMAT = "hoodie.table.base.file.format";
    public static final String HOODIE_TIMELINE_LAYOUT_VERSION_KEY = "hoodie.timeline.layout.version";
    private final Properties properties;

    public HudiTableConfig(TrinoFileSystem fs, Location metaPath) {
        block8: {
            this.properties = new Properties();
            Location propertyPath = metaPath.appendPath(HOODIE_PROPERTIES_FILE);
            try {
                TrinoInputFile inputFile = fs.newInputFile(propertyPath);
                try (TrinoInputStream inputStream = inputFile.newStream();){
                    this.properties.load((InputStream)inputStream);
                }
            }
            catch (IOException e) {
                if (this.tryLoadingBackupPropertyFile(fs, metaPath)) break block8;
                throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_FILESYSTEM_ERROR, String.format("Could not load Hoodie properties from %s", propertyPath));
            }
        }
        Preconditions.checkArgument((this.properties.containsKey(HOODIE_TABLE_NAME_KEY) && this.properties.containsKey(HOODIE_TABLE_TYPE_KEY) ? 1 : 0) != 0, (Object)"hoodie.properties file seems invalid. Please check for left over `.updated` files if any, manually copy it to hoodie.properties and retry");
    }

    private boolean tryLoadingBackupPropertyFile(TrinoFileSystem fs, Location metaPath) {
        Location backupPath = metaPath.appendPath(HOODIE_PROPERTIES_FILE_BACKUP);
        try {
            FileIterator fileIterator = fs.listFiles(metaPath);
            while (fileIterator.hasNext()) {
                if (!fileIterator.next().location().equals((Object)backupPath)) continue;
                TrinoInputFile inputFile = fs.newInputFile(backupPath);
                try (TrinoInputStream inputStream = inputFile.newStream();){
                    this.properties.load((InputStream)inputStream);
                }
                return true;
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_FILESYSTEM_ERROR, "Failed to load Hudi properties from file: " + backupPath, (Throwable)e);
        }
        return false;
    }

    public HudiTableType getTableType() {
        return HudiTableType.valueOf(this.properties.getProperty(HOODIE_TABLE_TYPE_KEY));
    }

    public HudiFileFormat getBaseFileFormat() {
        if (this.properties.containsKey(HOODIE_TABLE_BASE_FILE_FORMAT)) {
            return HudiFileFormat.valueOf(this.properties.getProperty(HOODIE_TABLE_BASE_FILE_FORMAT));
        }
        return HudiFileFormat.PARQUET;
    }

    public Optional<TimelineLayoutVersion> getTimelineLayoutVersion() {
        return Optional.ofNullable(this.properties.getProperty(HOODIE_TIMELINE_LAYOUT_VERSION_KEY)).map(Integer::parseInt).map(TimelineLayoutVersion::new);
    }
}

