/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.partition;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.filesystem.Location;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hudi.HudiErrorCode;
import io.trino.plugin.hudi.HudiUtil;
import io.trino.plugin.hudi.partition.HudiPartitionInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class HiveHudiPartitionInfo
implements HudiPartitionInfo {
    private final Table table;
    private final List<HiveColumnHandle> partitionColumnHandles;
    private final TupleDomain<HiveColumnHandle> constraintSummary;
    private final String hivePartitionName;
    private final List<Column> partitionColumns;
    private final HiveMetastore hiveMetastore;
    private String relativePartitionPath;
    private List<HivePartitionKey> hivePartitionKeys;

    public HiveHudiPartitionInfo(String hivePartitionName, List<Column> partitionColumns, List<HiveColumnHandle> partitionColumnHandles, TupleDomain<HiveColumnHandle> constraintSummary, Table table, HiveMetastore hiveMetastore) {
        this.table = table;
        this.partitionColumnHandles = partitionColumnHandles;
        this.constraintSummary = constraintSummary;
        this.hivePartitionName = hivePartitionName;
        this.partitionColumns = partitionColumns;
        if (partitionColumns.isEmpty()) {
            this.relativePartitionPath = "";
            this.hivePartitionKeys = Collections.emptyList();
        }
        this.hiveMetastore = hiveMetastore;
    }

    @Override
    public String getRelativePartitionPath() {
        if (this.relativePartitionPath == null) {
            this.loadPartitionInfo(this.hiveMetastore.getPartition(this.table, HiveUtil.toPartitionValues((String)this.hivePartitionName)));
        }
        return this.relativePartitionPath;
    }

    @Override
    public List<HivePartitionKey> getHivePartitionKeys() {
        if (this.hivePartitionKeys == null) {
            this.loadPartitionInfo(this.hiveMetastore.getPartition(this.table, HiveUtil.toPartitionValues((String)this.hivePartitionName)));
        }
        return this.hivePartitionKeys;
    }

    @Override
    public boolean doesMatchPredicates() {
        if (this.hivePartitionName.equals("")) {
            this.hivePartitionKeys = ImmutableList.of();
            return true;
        }
        return HudiUtil.partitionMatchesPredicates(this.table.getSchemaTableName(), this.hivePartitionName, this.partitionColumnHandles, this.constraintSummary);
    }

    @Override
    public void loadPartitionInfo(Optional<Partition> partition) {
        if (partition.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_PARTITION_NOT_FOUND, String.format("Cannot find partition in Hive Metastore: %s", this.hivePartitionName));
        }
        this.relativePartitionPath = HiveHudiPartitionInfo.getRelativePartitionPath(Location.of((String)this.table.getStorage().getLocation()), Location.of((String)partition.get().getStorage().getLocation()));
        this.hivePartitionKeys = HudiUtil.buildPartitionKeys(this.partitionColumns, partition.get().getValues());
    }

    private static String getRelativePartitionPath(Location baseLocation, Location fullPartitionLocation) {
        String basePath = baseLocation.path();
        String fullPartitionPath = fullPartitionLocation.path();
        if (!fullPartitionPath.startsWith(basePath)) {
            throw new IllegalArgumentException("Partition location does not belong to base-location");
        }
        String baseLocationParent = baseLocation.parentDirectory().path();
        String baseLocationName = baseLocation.fileName();
        int partitionStartIndex = fullPartitionPath.indexOf(baseLocationName, baseLocationParent == null ? 0 : baseLocationParent.length());
        boolean isNonPartitionedTable = partitionStartIndex + baseLocationName.length() == fullPartitionPath.length();
        return isNonPartitionedTable ? "" : fullPartitionPath.substring(partitionStartIndex + baseLocationName.length() + 1);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hivePartitionName", (Object)this.hivePartitionName).add("hivePartitionKeys", this.hivePartitionKeys).toString();
    }
}

