/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.partition;

import io.airlift.concurrent.MoreFutures;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.util.AsyncQueue;
import io.trino.plugin.hudi.HudiFileStatus;
import io.trino.plugin.hudi.partition.HudiPartitionInfo;
import io.trino.plugin.hudi.query.HudiDirectoryLister;
import io.trino.plugin.hudi.split.HudiSplitFactory;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Deque;
import java.util.List;
import java.util.Optional;

public class HudiPartitionInfoLoader
implements Runnable {
    private final HudiDirectoryLister hudiDirectoryLister;
    private final HudiSplitFactory hudiSplitFactory;
    private final AsyncQueue<ConnectorSplit> asyncQueue;
    private final Deque<String> partitionQueue;
    private boolean isRunning;

    public HudiPartitionInfoLoader(HudiDirectoryLister hudiDirectoryLister, HudiSplitFactory hudiSplitFactory, AsyncQueue<ConnectorSplit> asyncQueue, Deque<String> partitionQueue) {
        this.hudiDirectoryLister = hudiDirectoryLister;
        this.hudiSplitFactory = hudiSplitFactory;
        this.asyncQueue = asyncQueue;
        this.partitionQueue = partitionQueue;
        this.isRunning = true;
    }

    @Override
    public void run() {
        while (this.isRunning || !this.partitionQueue.isEmpty()) {
            String partitionName = this.partitionQueue.poll();
            if (partitionName == null) continue;
            this.generateSplitsFromPartition(partitionName);
        }
    }

    private void generateSplitsFromPartition(String partitionName) {
        Optional<HudiPartitionInfo> partitionInfo = this.hudiDirectoryLister.getPartitionInfo(partitionName);
        partitionInfo.ifPresent(hudiPartitionInfo -> {
            if (hudiPartitionInfo.doesMatchPredicates() || partitionName.equals("")) {
                List<HivePartitionKey> partitionKeys = hudiPartitionInfo.getHivePartitionKeys();
                List<HudiFileStatus> partitionFiles = this.hudiDirectoryLister.listStatus((HudiPartitionInfo)hudiPartitionInfo);
                partitionFiles.stream().flatMap(fileStatus -> this.hudiSplitFactory.createSplits(partitionKeys, (HudiFileStatus)fileStatus).stream()).map(arg_0 -> this.asyncQueue.offer(arg_0)).forEachOrdered(MoreFutures::getFutureValue);
            }
        });
    }

    public void stopRunning() {
        this.isRunning = false;
    }
}

