/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.split;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.plugin.hive.util.AsyncQueue;
import io.trino.plugin.hudi.HudiErrorCode;
import io.trino.plugin.hudi.HudiSessionProperties;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.plugin.hudi.partition.HudiPartitionInfoLoader;
import io.trino.plugin.hudi.query.HudiDirectoryLister;
import io.trino.plugin.hudi.split.HudiSplitFactory;
import io.trino.plugin.hudi.split.HudiSplitWeightProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

public class HudiBackgroundSplitLoader
implements Runnable {
    private final HudiDirectoryLister hudiDirectoryLister;
    private final AsyncQueue<ConnectorSplit> asyncQueue;
    private final Executor splitGeneratorExecutor;
    private final int splitGeneratorNumThreads;
    private final HudiSplitFactory hudiSplitFactory;
    private final List<String> partitions;

    public HudiBackgroundSplitLoader(ConnectorSession session, HudiTableHandle tableHandle, HudiDirectoryLister hudiDirectoryLister, AsyncQueue<ConnectorSplit> asyncQueue, Executor splitGeneratorExecutor, HudiSplitWeightProvider hudiSplitWeightProvider, List<String> partitions) {
        this.hudiDirectoryLister = Objects.requireNonNull(hudiDirectoryLister, "hudiDirectoryLister is null");
        this.asyncQueue = Objects.requireNonNull(asyncQueue, "asyncQueue is null");
        this.splitGeneratorExecutor = Objects.requireNonNull(splitGeneratorExecutor, "splitGeneratorExecutorService is null");
        this.splitGeneratorNumThreads = HudiSessionProperties.getSplitGeneratorParallelism(session);
        this.hudiSplitFactory = new HudiSplitFactory(tableHandle, hudiSplitWeightProvider);
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
    }

    @Override
    public void run() {
        ConcurrentLinkedDeque<String> partitionQueue = new ConcurrentLinkedDeque<String>(this.partitions);
        ArrayList<HudiPartitionInfoLoader> splitGeneratorList = new ArrayList<HudiPartitionInfoLoader>();
        ArrayList<ListenableFuture> splitGeneratorFutures = new ArrayList<ListenableFuture>();
        for (int i = 0; i < this.splitGeneratorNumThreads; ++i) {
            HudiPartitionInfoLoader hudiPartitionInfoLoader = new HudiPartitionInfoLoader(this.hudiDirectoryLister, this.hudiSplitFactory, this.asyncQueue, partitionQueue);
            splitGeneratorList.add(hudiPartitionInfoLoader);
            splitGeneratorFutures.add(Futures.submit((Runnable)hudiPartitionInfoLoader, (Executor)this.splitGeneratorExecutor));
        }
        for (HudiPartitionInfoLoader hudiPartitionInfoLoader : splitGeneratorList) {
            hudiPartitionInfoLoader.stopRunning();
        }
        for (Future future : splitGeneratorFutures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_CANNOT_OPEN_SPLIT, "Error generating Hudi split", (Throwable)e);
            }
        }
        this.asyncQueue.finish();
    }
}

