/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.table;

import com.google.common.base.Preconditions;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.hudi.HudiUtil;
import io.trino.plugin.hudi.config.HudiTableConfig;
import io.trino.plugin.hudi.model.HudiInstant;
import io.trino.plugin.hudi.model.HudiTableType;
import io.trino.plugin.hudi.timeline.HudiActiveTimeline;
import io.trino.plugin.hudi.timeline.HudiTimeline;
import io.trino.plugin.hudi.timeline.TimelineLayout;
import io.trino.plugin.hudi.timeline.TimelineLayoutVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HudiTableMetaClient {
    public static final String METAFOLDER_NAME = ".hoodie";
    public static final String SEPARATOR = "/";
    public static final String AUXILIARYFOLDER_NAME = ".hoodie/.aux";
    public static final String SCHEMA_FOLDER_NAME = ".schema";
    private final Location metaPath;
    private final Location basePath;
    private final HudiTableType tableType;
    private final TimelineLayoutVersion timelineLayoutVersion;
    private final HudiTableConfig tableConfig;
    private final TrinoFileSystem fileSystem;
    private HudiActiveTimeline activeTimeline;

    protected HudiTableMetaClient(TrinoFileSystem fileSystem, Location basePath, Optional<TimelineLayoutVersion> layoutVersion) {
        this.metaPath = Objects.requireNonNull(basePath, "basePath is null").appendPath(METAFOLDER_NAME);
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        Preconditions.checkArgument((boolean)HudiUtil.hudiMetadataExists(fileSystem, basePath), (String)"Could not check if %s is a valid table", (Object)basePath);
        this.basePath = basePath;
        this.tableConfig = new HudiTableConfig(fileSystem, this.metaPath);
        this.tableType = this.tableConfig.getTableType();
        Optional<TimelineLayoutVersion> tableConfigVersion = this.tableConfig.getTimelineLayoutVersion();
        if (layoutVersion.isPresent() && tableConfigVersion.isPresent()) {
            Preconditions.checkArgument((layoutVersion.get().compareTo(tableConfigVersion.get()) >= 0 ? 1 : 0) != 0, (String)"Layout Version defined in hoodie properties has higher version (%s) than the one passed in config (%s)", (Object)tableConfigVersion.get(), (Object)layoutVersion.get());
        }
        this.timelineLayoutVersion = layoutVersion.orElseGet(() -> this.tableConfig.getTimelineLayoutVersion().orElseThrow());
    }

    public HudiTableConfig getTableConfig() {
        return this.tableConfig;
    }

    public HudiTableType getTableType() {
        return this.tableType;
    }

    public HudiTimeline getCommitsTimeline() {
        return switch (this.getTableType()) {
            default -> throw new IncompatibleClassChangeError();
            case HudiTableType.COPY_ON_WRITE -> this.getActiveTimeline().getCommitTimeline();
            case HudiTableType.MERGE_ON_READ -> this.getActiveTimeline().getCommitsTimeline();
        };
    }

    public synchronized HudiActiveTimeline getActiveTimeline() {
        if (this.activeTimeline == null) {
            this.activeTimeline = new HudiActiveTimeline(this);
        }
        return this.activeTimeline;
    }

    public TimelineLayoutVersion getTimelineLayoutVersion() {
        return this.timelineLayoutVersion;
    }

    public Location getBasePath() {
        return this.basePath;
    }

    public Location getMetaPath() {
        return this.metaPath;
    }

    public TrinoFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getMetaAuxiliaryPath() {
        return this.basePath + "/.hoodie/.aux";
    }

    public String getSchemaFolderName() {
        return this.metaPath.appendPath(SCHEMA_FOLDER_NAME).path();
    }

    private static HudiTableMetaClient newMetaClient(TrinoFileSystem fileSystem, Location basePath) {
        return new HudiTableMetaClient(fileSystem, basePath, Optional.of(TimelineLayoutVersion.CURRENT_LAYOUT_VERSION));
    }

    public List<HudiInstant> scanHoodieInstantsFromFileSystem(Set<String> includedExtensions, boolean applyLayoutVersionFilters) throws IOException {
        Stream<HudiInstant> instantStream = this.scanFiles(location -> {
            String extension = HudiInstant.getTimelineFileExtension(location.fileName());
            return includedExtensions.contains(extension);
        }).stream().map(HudiInstant::new);
        if (applyLayoutVersionFilters) {
            instantStream = TimelineLayout.getLayout(this.getTimelineLayoutVersion()).filterHoodieInstants(instantStream);
        }
        return instantStream.sorted().collect(Collectors.toList());
    }

    private List<FileEntry> scanFiles(Predicate<Location> pathPredicate) throws IOException {
        FileIterator fileIterator = this.fileSystem.listFiles(this.metaPath);
        ArrayList<FileEntry> result = new ArrayList<FileEntry>();
        while (fileIterator.hasNext()) {
            FileEntry fileEntry = fileIterator.next();
            if (!pathPredicate.test(fileEntry.location())) continue;
            result.add(fileEntry);
        }
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TrinoFileSystem fileSystem;
        private Location basePath;

        public Builder setTrinoFileSystem(TrinoFileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public Builder setBasePath(Location basePath) {
            this.basePath = basePath;
            return this;
        }

        public HudiTableMetaClient build() {
            return HudiTableMetaClient.newMetaClient(this.fileSystem, this.basePath);
        }
    }
}

