/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;

public class ParquetWriterOptions {
    private static final DataSize DEFAULT_MAX_ROW_GROUP_SIZE = DataSize.ofBytes((long)0x8000000L);
    private static final DataSize DEFAULT_MAX_PAGE_SIZE = DataSize.ofBytes((long)0x100000L);
    public static final int DEFAULT_BATCH_SIZE = 10000;
    private final int maxRowGroupSize;
    private final int maxPageSize;
    private final int batchSize;

    public static Builder builder() {
        return new Builder();
    }

    private ParquetWriterOptions(DataSize maxBlockSize, DataSize maxPageSize, int batchSize) {
        this.maxRowGroupSize = Ints.saturatedCast((long)maxBlockSize.toBytes());
        this.maxPageSize = Ints.saturatedCast((long)maxPageSize.toBytes());
        this.batchSize = batchSize;
    }

    public int getMaxRowGroupSize() {
        return this.maxRowGroupSize;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public static class Builder {
        private DataSize maxBlockSize = DEFAULT_MAX_ROW_GROUP_SIZE;
        private DataSize maxPageSize = DEFAULT_MAX_PAGE_SIZE;
        private int batchSize = 10000;

        public Builder setMaxBlockSize(DataSize maxBlockSize) {
            this.maxBlockSize = maxBlockSize;
            return this;
        }

        public Builder setMaxPageSize(DataSize maxPageSize) {
            this.maxPageSize = maxPageSize;
            return this;
        }

        public Builder setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public ParquetWriterOptions build() {
            return new ParquetWriterOptions(this.maxBlockSize, this.maxPageSize, this.batchSize);
        }
    }
}

