/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ListenableFutureToApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc.GrpcClientCalls;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ApiCallContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.MethodDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.stub.ClientCalls;

class GrpcDirectCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final MethodDescriptor<RequestT, ResponseT> descriptor;
    private final boolean awaitTrailers;

    GrpcDirectCallable(MethodDescriptor<RequestT, ResponseT> descriptor, boolean awaitTrailers) {
        this.descriptor = Preconditions.checkNotNull(descriptor);
        this.awaitTrailers = awaitTrailers;
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(inputContext);
        ClientCall<RequestT, ResponseT> clientCall = GrpcClientCalls.newCall(this.descriptor, inputContext);
        if (this.awaitTrailers) {
            return new ListenableFutureToApiFuture<ResponseT>(ClientCalls.futureUnaryCall(clientCall, request));
        }
        return GrpcClientCalls.eagerFutureUnaryCall(clientCall, request);
    }

    public String toString() {
        return String.format("direct(%s)", this.descriptor);
    }
}

