/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.MetricsRecorder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.NoOpMetricsRecorder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.common.Duration;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.common.Scope;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.contrib.grpc.metrics.RpcViews;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.exporter.stats.stackdriver.StackdriverStatsConfiguration;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.exporter.stats.stackdriver.StackdriverStatsExporter;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.stats.Aggregation;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.stats.BucketBoundaries;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.stats.Measure;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.stats.Stats;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.stats.StatsRecorder;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.stats.View;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.stats.ViewManager;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.TagContext;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.TagContextBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.TagKey;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.TagMetadata;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.TagValue;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.Tagger;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.tags.Tags;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

class CloudMonitoringMetricsRecorder
implements MetricsRecorder {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    @VisibleForTesting
    static final Object monitor = new Object();
    private static final int EXPORT_INTERVAL = 5000;
    @GuardedBy(value="monitor")
    private static boolean initialized = false;
    private static final TagMetadata TAG_METADATA_NO_PROPAGATION = TagMetadata.create(TagMetadata.TagTtl.NO_PROPAGATION);
    static final String MS = "ms";
    static final String BY = "By";
    static final Measure.MeasureLong LATENCY_MS = Measure.MeasureLong.create("gcsio/latency", "The latency in milliseconds ", "ms");
    static final Measure.MeasureLong MESSAGE_LATENCY_MS = Measure.MeasureLong.create("gcsio/message/latency", "The latency in milliseconds per gcs message loop", "ms");
    static final Measure.MeasureLong REQUESTS = Measure.MeasureLong.create("gcsio/requests", "The distribution of retry attempts for gcs calls", "By");
    static final Measure.MeasureLong REQUEST_RETRIES = Measure.MeasureLong.create("gcsio/retries", "The distribution of retry attempts for gcs calls", "By");
    static final TagKey METHOD = TagKey.create("method");
    static final TagKey STATUS = TagKey.create("status");
    static final TagKey ERROR = TagKey.create("error");
    static final TagKey THREAD = TagKey.create("thread");
    static final TagKey PROTOCOL = TagKey.create("protocol");
    static final List<TagKey> TAG_KEYS = ImmutableList.of(METHOD, STATUS, ERROR, THREAD, PROTOCOL);
    static final List<Double> RPC_MILLIS_BUCKET_BOUNDARIES = ImmutableList.of(Double.valueOf(0.0), Double.valueOf(0.01), Double.valueOf(0.05), Double.valueOf(0.1), Double.valueOf(0.3), Double.valueOf(0.6), Double.valueOf(0.8), Double.valueOf(1.0), Double.valueOf(2.0), Double.valueOf(3.0), Double.valueOf(4.0), Double.valueOf(5.0), new Double[]{6.0, 8.0, 10.0, 13.0, 16.0, 20.0, 25.0, 30.0, 40.0, 50.0, 65.0, 80.0, 100.0, 130.0, 160.0, 200.0, 250.0, 300.0, 400.0, 500.0, 650.0, 800.0, 1000.0, 2000.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0});
    static final Aggregation AGGREGATION_WITH_MILLIS_HISTOGRAM = Aggregation.Distribution.create(BucketBoundaries.create(RPC_MILLIS_BUCKET_BOUNDARIES));
    static final Aggregation COUNT = Aggregation.Count.create();
    private static final Tagger tagger = Tags.getTagger();
    private static final StatsRecorder statsRecorder = Stats.getStatsRecorder();

    CloudMonitoringMetricsRecorder() {
    }

    public static MetricsRecorder create(String projectId, Credentials credentials) {
        try {
            CloudMonitoringMetricsRecorder.registerAllViews();
            CloudMonitoringMetricsRecorder.setupCloudMonitoringExporter(projectId, credentials);
        }
        catch (Exception e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Exception while registering metrics publisher");
            return new NoOpMetricsRecorder();
        }
        return new CloudMonitoringMetricsRecorder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupCloudMonitoringExporter(String projectId, Credentials credentials) throws IOException {
        Object object = monitor;
        synchronized (object) {
            if (!initialized) {
                StackdriverStatsExporter.createAndRegister(StackdriverStatsConfiguration.builder().setCredentials(credentials).setProjectId(projectId).setExportInterval(Duration.fromMillis(5000L)).build());
                Runtime.getRuntime().addShutdownHook(new Thread(StackdriverStatsExporter::unregister));
                initialized = true;
            }
        }
    }

    private static void registerAllViews() {
        View[] views = new View[]{View.create(View.Name.create("gcsio/latency"), "The distribution of latencies for a  method", LATENCY_MS, AGGREGATION_WITH_MILLIS_HISTOGRAM, TAG_KEYS), View.create(View.Name.create("gcsio/message/latency"), "The distribution of latencies at a message level in a streaming context", MESSAGE_LATENCY_MS, AGGREGATION_WITH_MILLIS_HISTOGRAM, TAG_KEYS), View.create(View.Name.create("gcsio/retries"), "The distribution of retry attempts for a method", REQUEST_RETRIES, COUNT, TAG_KEYS), View.create(View.Name.create("gcsio/requests"), "The distribution of request counts for a method", REQUESTS, COUNT, TAG_KEYS)};
        ViewManager viewManager = Stats.getViewManager();
        for (View view : views) {
            viewManager.registerView(view);
        }
        RpcViews.registerAllGrpcViews();
        RpcViews.registerRealTimeMetricsViews();
    }

    @Override
    public void recordTaggedStat(TagKey key, String value, Measure.MeasureLong ml, Long n) {
        TagContext tagContext = tagger.emptyBuilder().put(THREAD, TagValue.create(String.valueOf(Thread.currentThread().getId())), TAG_METADATA_NO_PROPAGATION).put(key, TagValue.create(value), TAG_METADATA_NO_PROPAGATION).build();
        try (Scope ignored = tagger.withTagContext(tagContext);){
            statsRecorder.newMeasureMap().put(ml, n).record();
        }
    }

    @Override
    public void recordLong(TagKey[] keys, String[] values, Measure.MeasureLong ml, Long n) {
        TagContextBuilder builder = tagger.emptyBuilder();
        for (int i = 0; i < keys.length; ++i) {
            builder.put(keys[i], TagValue.create(values[i]), TAG_METADATA_NO_PROPAGATION);
        }
        builder.put(THREAD, TagValue.create(String.valueOf(Thread.currentThread().getId())), TAG_METADATA_NO_PROPAGATION);
        TagContext tagContext = builder.build();
        try (Scope ignored = tagger.withTagContext(tagContext);){
            statsRecorder.newMeasureMap().put(ml, n).record();
        }
    }
}

