/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Objects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Stopwatch;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Supplier;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.util.Durations;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ChannelLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ConnectivityState;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ConnectivityStateInfo;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.SynchronizationContext;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.BackoffPolicy;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ExponentialBackoffPolicy;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.GrpcUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.util.ForwardingLoadBalancerHelper;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.util.ForwardingSubchannel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.OrcaPerRequestUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.shaded.com.github.xds.data.orca.v3.OrcaLoadReport;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.shaded.com.github.xds.service.orca.v3.OpenRcaServiceGrpc;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.shaded.com.github.xds.service.orca.v3.OrcaLoadReportRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

abstract class OrcaOobUtil {
    private static final Logger logger = Logger.getLogger(OrcaPerRequestUtil.class.getName());
    private static final OrcaOobUtil DEFAULT_INSTANCE = new OrcaOobUtil(){

        @Override
        public OrcaReportingHelperWrapper newOrcaReportingHelperWrapper(LoadBalancer.Helper delegate, OrcaOobReportListener listener) {
            return 1.newOrcaReportingHelperWrapper(delegate, listener, new ExponentialBackoffPolicy.Provider(), GrpcUtil.STOPWATCH_SUPPLIER);
        }
    };

    OrcaOobUtil() {
    }

    public static OrcaOobUtil getInstance() {
        return DEFAULT_INSTANCE;
    }

    public abstract OrcaReportingHelperWrapper newOrcaReportingHelperWrapper(LoadBalancer.Helper var1, OrcaOobReportListener var2);

    @VisibleForTesting
    static OrcaReportingHelperWrapper newOrcaReportingHelperWrapper(LoadBalancer.Helper delegate, OrcaOobReportListener listener, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        final OrcaReportingHelper orcaHelper = new OrcaReportingHelper(delegate, listener, backoffPolicyProvider, stopwatchSupplier);
        return new OrcaReportingHelperWrapper(){

            @Override
            public void setReportingConfig(OrcaReportingConfig config) {
                orcaHelper.setReportingConfig(config);
            }

            @Override
            public LoadBalancer.Helper asHelper() {
                return orcaHelper;
            }
        };
    }

    public static final class OrcaReportingConfig {
        private final long reportIntervalNanos;

        private OrcaReportingConfig(long reportIntervalNanos) {
            this.reportIntervalNanos = reportIntervalNanos;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public long getReportIntervalNanos() {
            return this.reportIntervalNanos;
        }

        public Builder toBuilder() {
            return OrcaReportingConfig.newBuilder().setReportInterval(this.reportIntervalNanos, TimeUnit.NANOSECONDS);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("reportIntervalNanos", this.reportIntervalNanos).toString();
        }

        public static final class Builder {
            private long reportIntervalNanos;

            Builder() {
            }

            public Builder setReportInterval(long reportInterval, TimeUnit unit) {
                this.reportIntervalNanos = unit.toNanos(reportInterval);
                return this;
            }

            public OrcaReportingConfig build() {
                return new OrcaReportingConfig(this.reportIntervalNanos);
            }
        }
    }

    @VisibleForTesting
    static final class SubchannelImpl
    extends ForwardingSubchannel {
        private final LoadBalancer.Subchannel delegate;
        private final OrcaReportingHelper.OrcaReportingState orcaState;

        SubchannelImpl(LoadBalancer.Subchannel delegate, OrcaReportingHelper.OrcaReportingState orcaState) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.orcaState = Preconditions.checkNotNull(orcaState, "orcaState");
        }

        @Override
        protected LoadBalancer.Subchannel delegate() {
            return this.delegate;
        }

        @Override
        public void start(LoadBalancer.SubchannelStateListener listener) {
            this.orcaState.init(this, listener);
            super.start(this.orcaState);
        }
    }

    private static final class OrcaReportingHelper
    extends ForwardingLoadBalancerHelper
    implements OrcaOobReportListener {
        private static final LoadBalancer.CreateSubchannelArgs.Key<OrcaReportingState> ORCA_REPORTING_STATE_KEY = LoadBalancer.CreateSubchannelArgs.Key.create("internal-orca-reporting-state");
        private final LoadBalancer.Helper delegate;
        private final OrcaOobReportListener listener;
        private final SynchronizationContext syncContext;
        private final BackoffPolicy.Provider backoffPolicyProvider;
        private final Supplier<Stopwatch> stopwatchSupplier;
        private final Set<OrcaReportingState> orcaStates = new HashSet<OrcaReportingState>();
        @Nullable
        private OrcaReportingConfig orcaConfig;

        OrcaReportingHelper(LoadBalancer.Helper delegate, OrcaOobReportListener listener, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.listener = Preconditions.checkNotNull(listener, "listener");
            this.backoffPolicyProvider = Preconditions.checkNotNull(backoffPolicyProvider, "backoffPolicyProvider");
            this.stopwatchSupplier = Preconditions.checkNotNull(stopwatchSupplier, "stopwatchSupplier");
            this.syncContext = Preconditions.checkNotNull(delegate.getSynchronizationContext(), "syncContext");
        }

        @Override
        protected LoadBalancer.Helper delegate() {
            return this.delegate;
        }

        @Override
        public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
            this.syncContext.throwIfNotInThisSynchronizationContext();
            OrcaReportingState orcaState = args.getOption(ORCA_REPORTING_STATE_KEY);
            boolean augmented = false;
            if (orcaState == null) {
                orcaState = new OrcaReportingState(this, this.syncContext, this.delegate().getScheduledExecutorService());
                args = args.toBuilder().addOption(ORCA_REPORTING_STATE_KEY, orcaState).build();
                augmented = true;
            }
            this.orcaStates.add(orcaState);
            orcaState.listeners.add(this);
            LoadBalancer.Subchannel subchannel = super.createSubchannel(args);
            if (augmented) {
                subchannel = new SubchannelImpl(subchannel, orcaState);
            }
            if (this.orcaConfig != null) {
                orcaState.setReportingConfig(this, this.orcaConfig);
            }
            return subchannel;
        }

        void setReportingConfig(OrcaReportingConfig config) {
            this.syncContext.throwIfNotInThisSynchronizationContext();
            this.orcaConfig = config;
            for (OrcaReportingState state : this.orcaStates) {
                state.setReportingConfig(this, config);
            }
        }

        @Override
        public void onLoadReport(OrcaLoadReport report) {
            this.syncContext.throwIfNotInThisSynchronizationContext();
            if (this.orcaConfig != null) {
                this.listener.onLoadReport(report);
            }
        }

        private final class OrcaReportingState
        implements LoadBalancer.SubchannelStateListener {
            private final OrcaReportingHelper orcaHelper;
            private final SynchronizationContext syncContext;
            private final ScheduledExecutorService timeService;
            private final List<OrcaOobReportListener> listeners = new ArrayList<OrcaOobReportListener>();
            private final Map<OrcaReportingHelper, OrcaReportingConfig> configs = new HashMap<OrcaReportingHelper, OrcaReportingConfig>();
            @Nullable
            private LoadBalancer.Subchannel subchannel;
            @Nullable
            private ChannelLogger subchannelLogger;
            @Nullable
            private LoadBalancer.SubchannelStateListener stateListener;
            @Nullable
            private BackoffPolicy backoffPolicy;
            @Nullable
            private OrcaReportingStream orcaRpc;
            @Nullable
            private SynchronizationContext.ScheduledHandle retryTimer;
            @Nullable
            private OrcaReportingConfig overallConfig;
            private final Runnable retryTask = new Runnable(){

                @Override
                public void run() {
                    OrcaReportingState.this.startRpc();
                }
            };
            private ConnectivityStateInfo state = ConnectivityStateInfo.forNonError(ConnectivityState.IDLE);
            private boolean disabled;

            OrcaReportingState(OrcaReportingHelper orcaHelper, SynchronizationContext syncContext, ScheduledExecutorService timeService) {
                this.orcaHelper = Preconditions.checkNotNull(orcaHelper, "orcaHelper");
                this.syncContext = Preconditions.checkNotNull(syncContext, "syncContext");
                this.timeService = Preconditions.checkNotNull(timeService, "timeService");
            }

            void init(LoadBalancer.Subchannel subchannel, LoadBalancer.SubchannelStateListener stateListener) {
                Preconditions.checkState(this.subchannel == null, "init() already called");
                this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
                this.subchannelLogger = Preconditions.checkNotNull(subchannel.getChannelLogger(), "subchannelLogger");
                this.stateListener = Preconditions.checkNotNull(stateListener, "stateListener");
            }

            void setReportingConfig(OrcaReportingHelper helper, OrcaReportingConfig config) {
                boolean reconfigured = false;
                this.configs.put(helper, config);
                if (this.overallConfig == null) {
                    this.overallConfig = config.toBuilder().build();
                    reconfigured = true;
                } else {
                    long minInterval = Long.MAX_VALUE;
                    for (OrcaReportingConfig c : this.configs.values()) {
                        if (c.getReportIntervalNanos() >= minInterval) continue;
                        minInterval = c.getReportIntervalNanos();
                    }
                    if (this.overallConfig.getReportIntervalNanos() != minInterval) {
                        this.overallConfig = this.overallConfig.toBuilder().setReportInterval(minInterval, TimeUnit.NANOSECONDS).build();
                        reconfigured = true;
                    }
                }
                if (reconfigured) {
                    this.stopRpc("ORCA reporting reconfigured");
                    this.adjustOrcaReporting();
                }
            }

            @Override
            public void onSubchannelState(ConnectivityStateInfo newState) {
                if (Objects.equal((Object)this.state.getState(), (Object)ConnectivityState.READY) && !Objects.equal((Object)newState.getState(), (Object)ConnectivityState.READY)) {
                    this.disabled = false;
                }
                if (Objects.equal((Object)newState.getState(), (Object)ConnectivityState.SHUTDOWN)) {
                    this.orcaHelper.orcaStates.remove(this);
                }
                this.state = newState;
                this.adjustOrcaReporting();
                this.stateListener.onSubchannelState(newState);
            }

            void adjustOrcaReporting() {
                if (!this.disabled && this.overallConfig != null && Objects.equal((Object)this.state.getState(), (Object)ConnectivityState.READY)) {
                    if (this.orcaRpc == null && !this.isRetryTimerPending()) {
                        this.startRpc();
                    }
                } else {
                    this.stopRpc("Client stops ORCA reporting");
                    this.backoffPolicy = null;
                }
            }

            void startRpc() {
                Preconditions.checkState(this.orcaRpc == null, "previous orca reporting RPC has not been cleaned up");
                Preconditions.checkState(this.subchannel != null, "init() not called");
                this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Starting ORCA reporting for {0}", this.subchannel.getAllAddresses());
                this.orcaRpc = new OrcaReportingStream(this.subchannel.asChannel(), (Stopwatch)OrcaReportingHelper.this.stopwatchSupplier.get());
                this.orcaRpc.start();
            }

            void stopRpc(String msg) {
                if (this.orcaRpc != null) {
                    this.orcaRpc.cancel(msg);
                    this.orcaRpc = null;
                }
                if (this.retryTimer != null) {
                    this.retryTimer.cancel();
                    this.retryTimer = null;
                }
            }

            boolean isRetryTimerPending() {
                return this.retryTimer != null && this.retryTimer.isPending();
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("disabled", this.disabled).add("orcaRpc", this.orcaRpc).add("reportingConfig", this.overallConfig).add("connectivityState", this.state).toString();
            }

            private class OrcaReportingStream
            extends ClientCall.Listener<OrcaLoadReport> {
                private final ClientCall<OrcaLoadReportRequest, OrcaLoadReport> call;
                private final Stopwatch stopwatch;
                private boolean callHasResponded;

                OrcaReportingStream(Channel channel, Stopwatch stopwatch) {
                    this.call = Preconditions.checkNotNull(channel, "channel").newCall(OpenRcaServiceGrpc.getStreamCoreMetricsMethod(), CallOptions.DEFAULT);
                    this.stopwatch = Preconditions.checkNotNull(stopwatch, "stopwatch");
                }

                void start() {
                    this.stopwatch.reset().start();
                    this.call.start(this, new Metadata());
                    this.call.sendMessage(OrcaLoadReportRequest.newBuilder().setReportInterval(Durations.fromNanos(OrcaReportingState.this.overallConfig.getReportIntervalNanos())).build());
                    this.call.halfClose();
                    this.call.request(1);
                }

                @Override
                public void onMessage(final OrcaLoadReport response) {
                    OrcaReportingState.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (OrcaReportingState.this.orcaRpc == OrcaReportingStream.this) {
                                OrcaReportingStream.this.handleResponse(response);
                            }
                        }
                    });
                }

                @Override
                public void onClose(final Status status, Metadata trailers) {
                    OrcaReportingState.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (OrcaReportingState.this.orcaRpc == OrcaReportingStream.this) {
                                OrcaReportingState.this.orcaRpc = null;
                                OrcaReportingStream.this.handleStreamClosed(status);
                            }
                        }
                    });
                }

                void handleResponse(OrcaLoadReport response) {
                    this.callHasResponded = true;
                    OrcaReportingState.this.backoffPolicy = null;
                    OrcaReportingState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Received an ORCA report: {0}", response);
                    for (OrcaOobReportListener listener : OrcaReportingState.this.listeners) {
                        listener.onLoadReport(response);
                    }
                    this.call.request(1);
                }

                void handleStreamClosed(Status status) {
                    if (Objects.equal((Object)status.getCode(), (Object)Status.Code.UNIMPLEMENTED)) {
                        OrcaReportingState.this.disabled = true;
                        logger.log(Level.SEVERE, "Backend {0} OpenRcaService is disabled. Server returned: {1}", new Object[]{OrcaReportingState.this.subchannel.getAllAddresses(), status});
                        OrcaReportingState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.ERROR, "OpenRcaService disabled: {0}", status);
                        return;
                    }
                    long delayNanos = 0L;
                    if (!this.callHasResponded) {
                        if (OrcaReportingState.this.backoffPolicy == null) {
                            OrcaReportingState.this.backoffPolicy = OrcaReportingHelper.this.backoffPolicyProvider.get();
                        }
                        delayNanos = OrcaReportingState.this.backoffPolicy.nextBackoffNanos() - this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
                    }
                    OrcaReportingState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "ORCA reporting stream closed with {0}, backoff in {1} ns", status, delayNanos <= 0L ? 0L : delayNanos);
                    if (delayNanos <= 0L) {
                        OrcaReportingState.this.startRpc();
                    } else {
                        Preconditions.checkState(!OrcaReportingState.this.isRetryTimerPending(), "Retry double scheduled");
                        OrcaReportingState.this.retryTimer = OrcaReportingState.this.syncContext.schedule(OrcaReportingState.this.retryTask, delayNanos, TimeUnit.NANOSECONDS, OrcaReportingState.this.timeService);
                    }
                }

                void cancel(String msg) {
                    this.call.cancel(msg, null);
                }

                public String toString() {
                    return MoreObjects.toStringHelper(this).add("callStarted", this.call != null).add("callHasResponded", this.callHasResponded).toString();
                }
            }
        }
    }

    public static abstract class OrcaReportingHelperWrapper {
        public abstract void setReportingConfig(OrcaReportingConfig var1);

        public abstract LoadBalancer.Helper asHelper();
    }

    public static interface OrcaOobReportListener {
        public void onLoadReport(OrcaLoadReport var1);
    }
}

