/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;

class ReplicaUnderConstruction
extends Block {
    private final DatanodeStorageInfo expectedLocation;
    private HdfsServerConstants.ReplicaState state;
    private boolean chosenAsPrimary;

    ReplicaUnderConstruction(Block block, DatanodeStorageInfo target, HdfsServerConstants.ReplicaState state) {
        super(block);
        this.expectedLocation = target;
        this.state = state;
        this.chosenAsPrimary = false;
    }

    DatanodeStorageInfo getExpectedStorageLocation() {
        return this.expectedLocation;
    }

    HdfsServerConstants.ReplicaState getState() {
        return this.state;
    }

    boolean getChosenAsPrimary() {
        return this.chosenAsPrimary;
    }

    void setState(HdfsServerConstants.ReplicaState s2) {
        this.state = s2;
    }

    void setChosenAsPrimary(boolean chosenAsPrimary) {
        this.chosenAsPrimary = chosenAsPrimary;
    }

    boolean isAlive() {
        return this.expectedLocation.getDatanodeDescriptor().isAlive();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(50);
        this.appendStringTo(b);
        return b.toString();
    }

    @Override
    public void appendStringTo(StringBuilder sb) {
        sb.append("ReplicaUC[").append(this.expectedLocation).append("|").append((Object)this.state).append("]");
    }
}

