/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.util.StringUtils;

public abstract class ReservedSpaceCalculator {
    private final DF usage;
    private final Configuration conf;
    private final StorageType storageType;

    ReservedSpaceCalculator(Configuration conf, DF usage, StorageType storageType) {
        this.usage = usage;
        this.conf = conf;
        this.storageType = storageType;
    }

    DF getUsage() {
        return this.usage;
    }

    long getReservedFromConf(String key, long defaultValue) {
        return this.conf.getLong(key + "." + StringUtils.toLowerCase(this.storageType.toString()), this.conf.getLongBytes(key, defaultValue));
    }

    abstract long getReserved();

    private static long getPercentage(long total, long percentage) {
        return total * percentage / 100L;
    }

    public static class ReservedSpaceCalculatorAggressive
    extends ReservedSpaceCalculator {
        private final long reservedBytes = this.getReservedFromConf("dfs.datanode.du.reserved", 0L);
        private final long reservedPct = this.getReservedFromConf("dfs.datanode.du.reserved.pct", 0L);

        public ReservedSpaceCalculatorAggressive(Configuration conf, DF usage, StorageType storageType) {
            super(conf, usage, storageType);
        }

        long getReservedBytes() {
            return this.reservedBytes;
        }

        long getReservedPct() {
            return this.reservedPct;
        }

        @Override
        long getReserved() {
            return Math.min(this.getReservedBytes(), ReservedSpaceCalculator.getPercentage(this.getUsage().getCapacity(), this.getReservedPct()));
        }
    }

    public static class ReservedSpaceCalculatorConservative
    extends ReservedSpaceCalculator {
        private final long reservedBytes = this.getReservedFromConf("dfs.datanode.du.reserved", 0L);
        private final long reservedPct = this.getReservedFromConf("dfs.datanode.du.reserved.pct", 0L);

        public ReservedSpaceCalculatorConservative(Configuration conf, DF usage, StorageType storageType) {
            super(conf, usage, storageType);
        }

        long getReservedBytes() {
            return this.reservedBytes;
        }

        long getReservedPct() {
            return this.reservedPct;
        }

        @Override
        long getReserved() {
            return Math.max(this.getReservedBytes(), ReservedSpaceCalculator.getPercentage(this.getUsage().getCapacity(), this.getReservedPct()));
        }
    }

    public static class ReservedSpaceCalculatorPercentage
    extends ReservedSpaceCalculator {
        private final long reservedPct = this.getReservedFromConf("dfs.datanode.du.reserved.pct", 0L);

        public ReservedSpaceCalculatorPercentage(Configuration conf, DF usage, StorageType storageType) {
            super(conf, usage, storageType);
        }

        @Override
        long getReserved() {
            return ReservedSpaceCalculator.getPercentage(this.getUsage().getCapacity(), this.reservedPct);
        }
    }

    public static class ReservedSpaceCalculatorAbsolute
    extends ReservedSpaceCalculator {
        private final long reservedBytes = this.getReservedFromConf("dfs.datanode.du.reserved", 0L);

        public ReservedSpaceCalculatorAbsolute(Configuration conf, DF usage, StorageType storageType) {
            super(conf, usage, storageType);
        }

        @Override
        long getReserved() {
            return this.reservedBytes;
        }
    }

    public static class Builder {
        private final Configuration conf;
        private DF usage;
        private StorageType storageType;

        public Builder(Configuration conf) {
            this.conf = conf;
        }

        public Builder setUsage(DF newUsage) {
            this.usage = newUsage;
            return this;
        }

        public Builder setStorageType(StorageType newStorageType) {
            this.storageType = newStorageType;
            return this;
        }

        ReservedSpaceCalculator build() {
            try {
                Class<ReservedSpaceCalculator> clazz = this.conf.getClass("dfs.datanode.du.reserved.calculator", DFSConfigKeys.DFS_DATANODE_DU_RESERVED_CALCULATOR_DEFAULT, ReservedSpaceCalculator.class);
                Constructor<ReservedSpaceCalculator> constructor = clazz.getConstructor(Configuration.class, DF.class, StorageType.class);
                return constructor.newInstance(new Object[]{this.conf, this.usage, this.storageType});
            }
            catch (Exception e) {
                throw new IllegalStateException("Error instantiating ReservedSpaceCalculator", e);
            }
        }
    }
}

