/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import io.trino.hadoop.$internal.org.apache.commons.lang3.StringUtils;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.collect.Iterables;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.OutputValidationException;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.util.functional.TaskPool;

public class ValidateRenamedFilesStage
extends AbstractJobOrTaskStage<List<TaskManifest>, List<FileEntry>> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateRenamedFilesStage.class);
    private final AtomicBoolean halt = new AtomicBoolean();
    private List<FileEntry> filesCommitted = new ArrayList<FileEntry>();

    public ValidateRenamedFilesStage(StageConfig stageConfig) {
        super(false, stageConfig, "job_stage_optional_validate_output", true);
    }

    private synchronized List<FileEntry> getFilesCommitted() {
        return this.filesCommitted;
    }

    private synchronized void addFileCommitted(FileEntry entry) {
        this.filesCommitted.add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<FileEntry> executeStage(List<TaskManifest> taskManifests) throws IOException {
        ValidateRenamedFilesStage validateRenamedFilesStage = this;
        synchronized (validateRenamedFilesStage) {
            this.filesCommitted = new ArrayList<FileEntry>(taskManifests.size());
        }
        Iterable filesToCommit = Iterables.concat(taskManifests.stream().map(TaskManifest::getFilesToCommit).collect(Collectors.toList()));
        TaskPool.foreach(filesToCommit).executeWith(this.getIOProcessors()).stopOnFailure().run(this::validateOneFile);
        return this.getFilesCommitted();
    }

    private void validateOneFile(FileEntry entry) throws IOException {
        this.updateAuditContext("job_stage_optional_validate_output");
        if (this.halt.get()) {
            return;
        }
        this.progress();
        Path sourcePath = entry.getSourcePath();
        Path destPath = entry.getDestPath();
        try {
            String destEtag;
            FileStatus destStatus = this.getFileStatus(destPath);
            if (!destStatus.isFile()) {
                throw new OutputValidationException(destPath, "Expected a file renamed from " + sourcePath + "; found " + destStatus);
            }
            long sourceSize = entry.getSize();
            long destSize = destStatus.getLen();
            String sourceEtag = entry.getEtag();
            if (StringUtils.isNotBlank(sourceEtag) && !sourceEtag.equals(destEtag = ManifestCommitterSupport.getEtag(destStatus))) {
                LOG.warn("Etag of dest file {}: {} does not match that of manifest entry {}", destPath, destStatus, entry);
                throw new OutputValidationException(destPath, String.format("Expected the file renamed from %s with etag %s and length %s but found a file with etag %s and length %d", sourcePath, sourceEtag, sourceSize, destEtag, destSize));
            }
            if (destSize != sourceSize) {
                LOG.warn("Length of dest file {}: {} does not match that of manifest entry {}", destPath, destStatus, entry);
                throw new OutputValidationException(destPath, String.format("Expected the file renamed from %s with length %d but found a file of length %d", sourcePath, sourceSize, destSize));
            }
        }
        catch (FileNotFoundException e) {
            throw new OutputValidationException(destPath, "Expected a file, but it was not found", (Throwable)e);
        }
        this.addFileCommitted(entry);
    }
}

