/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.rubix;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class RubixConfig {
    private ReadMode readMode = ReadMode.ASYNC;
    private Optional<String> cacheLocation = Optional.empty();
    private Duration cacheTtl = new Duration(7.0, TimeUnit.DAYS);
    private int diskUsagePercentage = 80;
    private int bookKeeperServerPort = 8899;
    private int dataTransferServerPort = 8898;
    private boolean startServerOnCoordinator;

    @NotNull
    public ReadMode getReadMode() {
        return this.readMode;
    }

    @Config(value="hive.cache.read-mode")
    public RubixConfig setReadMode(ReadMode readMode) {
        this.readMode = readMode;
        return this;
    }

    @NotNull
    public Optional<String> getCacheLocation() {
        return this.cacheLocation;
    }

    @Config(value="hive.cache.location")
    public RubixConfig setCacheLocation(String location) {
        this.cacheLocation = Optional.ofNullable(location);
        return this;
    }

    @MinDuration(value="0s")
    @NotNull
    public @MinDuration(value="0s") @NotNull Duration getCacheTtl() {
        return this.cacheTtl;
    }

    @Config(value="hive.cache.ttl")
    @ConfigDescription(value="Time files will be kept in cache prior to eviction")
    public RubixConfig setCacheTtl(Duration cacheTtl) {
        this.cacheTtl = cacheTtl;
        return this;
    }

    @Min(value=0L)
    @Max(value=100L)
    public @Min(value=0L) @Max(value=100L) int getDiskUsagePercentage() {
        return this.diskUsagePercentage;
    }

    @Config(value="hive.cache.disk-usage-percentage")
    @ConfigDescription(value="Percentage of disk space used for cached data")
    public RubixConfig setDiskUsagePercentage(int diskUsagePercentage) {
        this.diskUsagePercentage = diskUsagePercentage;
        return this;
    }

    public int getBookKeeperServerPort() {
        return this.bookKeeperServerPort;
    }

    @Config(value="hive.cache.bookkeeper-port")
    public RubixConfig setBookKeeperServerPort(int port) {
        this.bookKeeperServerPort = port;
        return this;
    }

    public int getDataTransferServerPort() {
        return this.dataTransferServerPort;
    }

    @Config(value="hive.cache.data-transfer-port")
    public RubixConfig setDataTransferServerPort(int port) {
        this.dataTransferServerPort = port;
        return this;
    }

    public boolean isStartServerOnCoordinator() {
        return this.startServerOnCoordinator;
    }

    @Config(value="hive.cache.start-server-on-coordinator")
    public RubixConfig setStartServerOnCoordinator(boolean startServerOnCoordinator) {
        this.startServerOnCoordinator = startServerOnCoordinator;
        return this;
    }

    public static enum ReadMode {
        READ_THROUGH(false),
        ASYNC(true);

        private final boolean parallelWarmupEnabled;

        private ReadMode(boolean parallelWarmupEnabled) {
            this.parallelWarmupEnabled = parallelWarmupEnabled;
        }

        public boolean isParallelWarmupEnabled() {
            return this.parallelWarmupEnabled;
        }

        public static ReadMode fromString(String value) {
            switch (value.toLowerCase(Locale.ENGLISH)) {
                case "async": {
                    return ASYNC;
                }
                case "read-through": {
                    return READ_THROUGH;
                }
            }
            throw new IllegalArgumentException(String.format("Unrecognized value: '%s'", value));
        }
    }
}

