/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.util.HiveBucketing;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class HiveBucketHandle {
    private final List<HiveColumnHandle> columns;
    private final HiveBucketing.BucketingVersion bucketingVersion;
    private final int tableBucketCount;
    private final int readBucketCount;
    private final List<SortingColumn> sortedBy;

    @JsonCreator
    public HiveBucketHandle(@JsonProperty(value="columns") List<HiveColumnHandle> columns, @JsonProperty(value="bucketingVersion") HiveBucketing.BucketingVersion bucketingVersion, @JsonProperty(value="tableBucketCount") int tableBucketCount, @JsonProperty(value="readBucketCount") int readBucketCount, @JsonProperty(value="sortedBy") List<SortingColumn> sortedBy) {
        this.columns = Objects.requireNonNull(columns, "columns is null");
        columns.forEach(column -> Preconditions.checkArgument((boolean)column.isBaseColumn(), (Object)String.format("projected column %s is not allowed for bucketing", column)));
        this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
        this.tableBucketCount = tableBucketCount;
        this.readBucketCount = readBucketCount;
        this.sortedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortedBy, "sortedBy is null"));
    }

    @JsonProperty
    public List<HiveColumnHandle> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public HiveBucketing.BucketingVersion getBucketingVersion() {
        return this.bucketingVersion;
    }

    @JsonProperty
    public int getTableBucketCount() {
        return this.tableBucketCount;
    }

    @JsonProperty
    public int getReadBucketCount() {
        return this.readBucketCount;
    }

    @JsonProperty
    public List<SortingColumn> getSortedBy() {
        return this.sortedBy;
    }

    public HiveBucketProperty toTableBucketProperty() {
        return new HiveBucketProperty(this.columns.stream().map(HiveColumnHandle::getName).collect(Collectors.toList()), this.bucketingVersion, this.tableBucketCount, this.sortedBy);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HiveBucketHandle other = (HiveBucketHandle)obj;
        return Objects.equals(this.columns, other.columns) && this.bucketingVersion == other.bucketingVersion && this.tableBucketCount == other.tableBucketCount && this.readBucketCount == other.readBucketCount && Objects.equals(this.sortedBy, other.sortedBy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columns, this.bucketingVersion, this.tableBucketCount, this.readBucketCount, this.sortedBy});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columns).add("bucketingVersion", (Object)this.bucketingVersion).add("tableBucketCount", this.tableBucketCount).add("readBucketCount", this.readBucketCount).add("sortedBy", this.sortedBy).toString();
    }
}

