/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.avro;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.memory.MemoryInputFile;
import io.trino.hive.formats.avro.AvroTypeManager;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.avro.AvroHiveFileUtils;
import io.trino.plugin.hive.avro.AvroPageSource;
import io.trino.plugin.hive.avro.HiveAvroTypeManager;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.predicate.TupleDomain;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.util.internal.Accessor;

public class AvroPageSourceFactory
implements HivePageSourceFactory {
    private static final DataSize BUFFER_SIZE = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private final TrinoFileSystemFactory trinoFileSystemFactory;

    @Inject
    public AvroPageSourceFactory(TrinoFileSystemFactory trinoFileSystemFactory) {
        this.trinoFileSystemFactory = Objects.requireNonNull(trinoFileSystemFactory, "trinoFileSystemFactory is null");
    }

    @Override
    public Optional<ReaderPageSource> createPageSource(ConnectorSession session, Location path, long start, long length, long estimatedFileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, Optional<AcidInfo> acidInfo, OptionalInt bucketNumber, boolean originalFile, AcidTransaction transaction) {
        Schema maskedSchema;
        Schema tableSchema;
        HiveTimestampPrecision hiveTimestampPrecision;
        TrinoInputFile inputFile;
        Optional<ReaderColumns> readerProjections;
        List projectedReaderColumns;
        block25: {
            if (!"org.apache.hadoop.hive.serde2.avro.AvroSerDe".equals(HiveUtil.getDeserializerClassName(schema))) {
                return Optional.empty();
            }
            Preconditions.checkArgument((boolean)acidInfo.isEmpty(), (Object)"Acid is not supported");
            projectedReaderColumns = columns;
            readerProjections = HivePageSourceProvider.projectBaseColumns(columns);
            if (readerProjections.isPresent()) {
                projectedReaderColumns = (List)readerProjections.get().get().stream().map(HiveColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
            }
            TrinoFileSystem trinoFileSystem = this.trinoFileSystemFactory.create(session.getIdentity());
            inputFile = trinoFileSystem.newInputFile(path);
            hiveTimestampPrecision = HiveSessionProperties.getTimestampPrecision(session);
            try {
                tableSchema = AvroHiveFileUtils.determineSchemaOrThrowException(trinoFileSystem, schema);
            }
            catch (IOException | AvroTypeException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "Unable to load or parse schema", e);
            }
            try {
                length = Math.min(inputFile.length() - start, length);
                if (estimatedFileSize >= BUFFER_SIZE.toBytes()) break block25;
                try (TrinoInputStream input = inputFile.newStream();){
                    byte[] data = input.readAllBytes();
                    inputFile = new MemoryInputFile(path, Slices.wrappedBuffer((byte[])data));
                }
            }
            catch (TrinoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, HiveUtil.splitError(e, path, start, length), (Throwable)e);
            }
        }
        if (length <= 0L) {
            return Optional.of(ReaderPageSource.noProjectionAdaptation((ConnectorPageSource)new EmptyPageSource()));
        }
        try {
            maskedSchema = this.maskColumnsFromTableSchema(projectedReaderColumns, tableSchema);
        }
        catch (AvroTypeException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "Avro type resolution error when initializing split from %s".formatted(path), (Throwable)e);
        }
        if (maskedSchema.getFields().isEmpty()) {
            SchemaBuilder.FieldAssembler nullSchema = SchemaBuilder.record((String)"null_only").fields();
            for (int i = 0; i < Math.max(projectedReaderColumns.size(), 1); ++i) {
                String notAColumnName = null;
                while (Objects.isNull(notAColumnName) || Objects.nonNull(tableSchema.getField(notAColumnName))) {
                    notAColumnName = "f" + UUID.randomUUID().toString().replace('-', '_');
                }
                nullSchema = nullSchema.name(notAColumnName).type(Schema.create((Schema.Type)Schema.Type.NULL)).withDefault(null);
            }
            try {
                return Optional.of(ReaderPageSource.noProjectionAdaptation(new AvroPageSource(inputFile, (Schema)nullSchema.endRecord(), (AvroTypeManager)new HiveAvroTypeManager(hiveTimestampPrecision), start, length)));
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            catch (io.trino.hive.formats.avro.AvroTypeException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "Avro type resolution error when initializing split from %s".formatted(path), (Throwable)e);
            }
        }
        try {
            return Optional.of(new ReaderPageSource(new AvroPageSource(inputFile, maskedSchema, (AvroTypeManager)new HiveAvroTypeManager(hiveTimestampPrecision), start, length), readerProjections));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
        }
        catch (io.trino.hive.formats.avro.AvroTypeException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "Avro type resolution error when initializing split from %s".formatted(path), (Throwable)e);
        }
    }

    private Schema maskColumnsFromTableSchema(List<HiveColumnHandle> columns, Schema tableSchema) {
        Verify.verify((tableSchema.getType() == Schema.Type.RECORD ? 1 : 0) != 0);
        Set maskedColumns = columns.stream().map(HiveColumnHandle::getBaseColumnName).collect(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll);
        SchemaBuilder.FieldAssembler maskedSchema = ((SchemaBuilder.RecordBuilder)SchemaBuilder.builder().record(tableSchema.getName()).namespace(tableSchema.getNamespace())).fields();
        for (String columnName : maskedColumns) {
            Schema.Field field = tableSchema.getField(columnName);
            if (Objects.isNull(field)) continue;
            if (field.hasDefaultValue()) {
                try {
                    JsonNode defaultObj = Accessor.defaultValue((Schema.Field)field);
                    maskedSchema = ((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)maskedSchema.name(field.name()).aliases((String[])field.aliases().toArray(String[]::new))).doc(field.doc())).type(field.schema()).withDefault((Object)defaultObj);
                    continue;
                }
                catch (AvroTypeException e) {
                    if (e.getMessage().contains("Invalid default")) {
                        maskedSchema = ((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)maskedSchema.name(field.name()).aliases((String[])field.aliases().toArray(String[]::new))).doc(field.doc())).type(AvroHiveFileUtils.wrapInUnionWithNull(field.schema())).withDefault(null);
                        continue;
                    }
                    throw e;
                }
            }
            maskedSchema = ((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)maskedSchema.name(field.name()).aliases((String[])field.aliases().toArray(String[]::new))).doc(field.doc())).type(field.schema()).noDefault();
        }
        return (Schema)maskedSchema.endRecord();
    }
}

