/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.aws.athena.projection;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.aws.athena.projection.Projection;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class EnumProjection
extends Projection {
    private final List<String> values;

    public EnumProjection(String columnName, List<String> values) {
        super(columnName);
        this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values is null"));
    }

    @Override
    public List<String> getProjectedValues(Optional<Domain> partitionValueFilter) {
        if (partitionValueFilter.isEmpty() || partitionValueFilter.get().isAll()) {
            return this.values;
        }
        return this.values.stream().filter(value -> this.isValueInDomain((Domain)partitionValueFilter.get(), (String)value)).collect(Collectors.toList());
    }

    private boolean isValueInDomain(Domain valueDomain, String value) {
        Type type = valueDomain.getType();
        if (type instanceof VarcharType) {
            return valueDomain.contains(Domain.singleValue((Type)type, (Object)Slices.utf8Slice((String)value)));
        }
        throw this.unsupportedProjectionColumnTypeException(type);
    }
}

