/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.coercions.CharCoercer;
import io.trino.plugin.hive.coercions.DecimalCoercers;
import io.trino.plugin.hive.coercions.DoubleToFloatCoercer;
import io.trino.plugin.hive.coercions.DoubleToVarcharCoercer;
import io.trino.plugin.hive.coercions.FloatToDoubleCoercer;
import io.trino.plugin.hive.coercions.IntegerNumberToVarcharCoercer;
import io.trino.plugin.hive.coercions.IntegerNumberUpscaleCoercer;
import io.trino.plugin.hive.coercions.TimestampCoercer;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.coercions.VarcharCoercer;
import io.trino.plugin.hive.coercions.VarcharToIntegerNumberCoercer;
import io.trino.plugin.hive.type.Category;
import io.trino.plugin.hive.type.ListTypeInfo;
import io.trino.plugin.hive.type.MapTypeInfo;
import io.trino.plugin.hive.type.StructTypeInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class CoercionUtils {
    private CoercionUtils() {
    }

    public static Type createTypeFromCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType, CoercionContext coercionContext) {
        return CoercionUtils.createCoercer(typeManager, fromHiveType, toHiveType, coercionContext).map(TypeCoercer::getFromType).orElseGet(() -> fromHiveType.getType(typeManager, coercionContext.timestampPrecision()));
    }

    public static Optional<TypeCoercer<? extends Type, ? extends Type>> createCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType, CoercionContext coercionContext) {
        DecimalType toDecimalType;
        DecimalType fromDecimalType;
        VarcharType varcharType;
        VarcharType fromVarcharType;
        VarcharType toVarcharType;
        if (fromHiveType.equals(toHiveType)) {
            return Optional.empty();
        }
        Type fromType = fromHiveType.getType(typeManager, coercionContext.timestampPrecision());
        Type toType = toHiveType.getType(typeManager, coercionContext.timestampPrecision());
        if (toType instanceof VarcharType) {
            toVarcharType = (VarcharType)toType;
            if (fromHiveType.equals(HiveType.HIVE_BYTE) || fromHiveType.equals(HiveType.HIVE_SHORT) || fromHiveType.equals(HiveType.HIVE_INT) || fromHiveType.equals(HiveType.HIVE_LONG)) {
                return Optional.of(new IntegerNumberToVarcharCoercer<Type>(fromType, toVarcharType));
            }
        }
        if (fromType instanceof VarcharType) {
            fromVarcharType = (VarcharType)fromType;
            if (toHiveType.equals(HiveType.HIVE_BYTE) || toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG)) {
                return Optional.of(new VarcharToIntegerNumberCoercer<Type>(fromVarcharType, toType));
            }
        }
        if (fromType instanceof VarcharType) {
            varcharType = (VarcharType)fromType;
            if (toType instanceof TimestampType) {
                TimestampType timestampType = (TimestampType)toType;
                if (timestampType.isShort()) {
                    return Optional.of(new TimestampCoercer.VarcharToShortTimestampCoercer(varcharType, timestampType));
                }
                return Optional.of(new TimestampCoercer.VarcharToLongTimestampCoercer(varcharType, timestampType));
            }
        }
        if (fromType instanceof VarcharType) {
            fromVarcharType = (VarcharType)fromType;
            if (toType instanceof VarcharType) {
                VarcharType toVarcharType2 = (VarcharType)toType;
                if (CoercionUtils.narrowerThan(toVarcharType2, fromVarcharType)) {
                    return Optional.of(new VarcharCoercer(fromVarcharType, toVarcharType2));
                }
                return Optional.empty();
            }
        }
        if (fromType instanceof CharType) {
            CharType fromCharType = (CharType)fromType;
            if (toType instanceof CharType) {
                CharType toCharType = (CharType)toType;
                if (CoercionUtils.narrowerThan(toCharType, fromCharType)) {
                    return Optional.of(new CharCoercer(fromCharType, toCharType));
                }
                return Optional.empty();
            }
        }
        if (fromHiveType.equals(HiveType.HIVE_BYTE) && (toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG))) {
            return Optional.of(new IntegerNumberUpscaleCoercer<Type, Type>(fromType, toType));
        }
        if (fromHiveType.equals(HiveType.HIVE_SHORT) && (toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG))) {
            return Optional.of(new IntegerNumberUpscaleCoercer<Type, Type>(fromType, toType));
        }
        if (fromHiveType.equals(HiveType.HIVE_INT) && toHiveType.equals(HiveType.HIVE_LONG)) {
            return Optional.of(new IntegerNumberUpscaleCoercer<Type, Type>(fromType, toType));
        }
        if (fromHiveType.equals(HiveType.HIVE_FLOAT) && toHiveType.equals(HiveType.HIVE_DOUBLE)) {
            return Optional.of(new FloatToDoubleCoercer());
        }
        if (fromHiveType.equals(HiveType.HIVE_DOUBLE) && toHiveType.equals(HiveType.HIVE_FLOAT)) {
            return Optional.of(new DoubleToFloatCoercer());
        }
        if (fromType instanceof DecimalType) {
            fromDecimalType = (DecimalType)fromType;
            if (toType instanceof DecimalType) {
                DecimalType toDecimalType2 = (DecimalType)toType;
                return Optional.of(DecimalCoercers.createDecimalToDecimalCoercer(fromDecimalType, toDecimalType2));
            }
        }
        if (fromType instanceof DecimalType) {
            fromDecimalType = (DecimalType)fromType;
            if (toType == DoubleType.DOUBLE) {
                return Optional.of(DecimalCoercers.createDecimalToDoubleCoercer(fromDecimalType));
            }
        }
        if (fromType instanceof DecimalType) {
            fromDecimalType = (DecimalType)fromType;
            if (toType == RealType.REAL) {
                return Optional.of(DecimalCoercers.createDecimalToRealCoercer(fromDecimalType));
            }
        }
        if (fromType instanceof DecimalType) {
            fromDecimalType = (DecimalType)fromType;
            if (toType instanceof VarcharType) {
                VarcharType toVarcharType3 = (VarcharType)toType;
                return Optional.of(DecimalCoercers.createDecimalToVarcharCoercer(fromDecimalType, toVarcharType3));
            }
        }
        if (fromType == DoubleType.DOUBLE && toType instanceof DecimalType) {
            toDecimalType = (DecimalType)toType;
            return Optional.of(DecimalCoercers.createDoubleToDecimalCoercer(toDecimalType));
        }
        if (fromType == RealType.REAL && toType instanceof DecimalType) {
            toDecimalType = (DecimalType)toType;
            return Optional.of(DecimalCoercers.createRealToDecimalCoercer(toDecimalType));
        }
        if (fromType instanceof TimestampType && toType instanceof VarcharType) {
            varcharType = (VarcharType)toType;
            return Optional.of(new TimestampCoercer.LongTimestampToVarcharCoercer(TimestampType.TIMESTAMP_NANOS, varcharType));
        }
        if (fromType == DoubleType.DOUBLE && toType instanceof VarcharType) {
            toVarcharType = (VarcharType)toType;
            return Optional.of(new DoubleToVarcharCoercer(toVarcharType, coercionContext.treatNaNAsNull()));
        }
        if (fromType instanceof ArrayType && toType instanceof ArrayType) {
            return CoercionUtils.createCoercerForList(typeManager, (ListTypeInfo)fromHiveType.getTypeInfo(), (ListTypeInfo)toHiveType.getTypeInfo(), coercionContext);
        }
        if (fromType instanceof MapType && toType instanceof MapType) {
            return CoercionUtils.createCoercerForMap(typeManager, (MapTypeInfo)fromHiveType.getTypeInfo(), (MapTypeInfo)toHiveType.getTypeInfo(), coercionContext);
        }
        if (fromType instanceof RowType && toType instanceof RowType) {
            HiveType fromHiveTypeStruct = fromHiveType.getCategory() == Category.UNION ? HiveType.toHiveType(fromType) : fromHiveType;
            HiveType toHiveTypeStruct = toHiveType.getCategory() == Category.UNION ? HiveType.toHiveType(toType) : toHiveType;
            return CoercionUtils.createCoercerForStruct(typeManager, (StructTypeInfo)fromHiveTypeStruct.getTypeInfo(), (StructTypeInfo)toHiveTypeStruct.getTypeInfo(), coercionContext);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported coercion from %s to %s", fromHiveType, toHiveType));
    }

    public static boolean narrowerThan(VarcharType first, VarcharType second) {
        Objects.requireNonNull(first, "first is null");
        Objects.requireNonNull(second, "second is null");
        if (first.isUnbounded() || second.isUnbounded()) {
            return !first.isUnbounded();
        }
        return first.getBoundedLength() < second.getBoundedLength();
    }

    public static boolean narrowerThan(CharType first, CharType second) {
        Objects.requireNonNull(first, "first is null");
        Objects.requireNonNull(second, "second is null");
        return first.getLength() < second.getLength();
    }

    private static Optional<TypeCoercer<? extends Type, ? extends Type>> createCoercerForList(TypeManager typeManager, ListTypeInfo fromListTypeInfo, ListTypeInfo toListTypeInfo, CoercionContext coercionContext) {
        HiveType fromElementHiveType = HiveType.valueOf(fromListTypeInfo.getListElementTypeInfo().getTypeName());
        HiveType toElementHiveType = HiveType.valueOf(toListTypeInfo.getListElementTypeInfo().getTypeName());
        return CoercionUtils.createCoercer(typeManager, fromElementHiveType, toElementHiveType, coercionContext).map(elementCoercer -> new ListCoercer(new ArrayType(elementCoercer.getFromType()), new ArrayType(elementCoercer.getToType()), (TypeCoercer<? extends Type, ? extends Type>)elementCoercer));
    }

    private static Optional<TypeCoercer<? extends Type, ? extends Type>> createCoercerForMap(TypeManager typeManager, MapTypeInfo fromMapTypeInfo, MapTypeInfo toMapTypeInfo, CoercionContext coercionContext) {
        HiveType fromKeyHiveType = HiveType.valueOf(fromMapTypeInfo.getMapKeyTypeInfo().getTypeName());
        HiveType fromValueHiveType = HiveType.valueOf(fromMapTypeInfo.getMapValueTypeInfo().getTypeName());
        HiveType toKeyHiveType = HiveType.valueOf(toMapTypeInfo.getMapKeyTypeInfo().getTypeName());
        HiveType toValueHiveType = HiveType.valueOf(toMapTypeInfo.getMapValueTypeInfo().getTypeName());
        Optional<TypeCoercer<? extends Type, ? extends Type>> keyCoercer = CoercionUtils.createCoercer(typeManager, fromKeyHiveType, toKeyHiveType, coercionContext);
        Optional<TypeCoercer<? extends Type, ? extends Type>> valueCoercer = CoercionUtils.createCoercer(typeManager, fromValueHiveType, toValueHiveType, coercionContext);
        MapType fromType = new MapType(keyCoercer.map(TypeCoercer::getFromType).orElseGet(() -> fromKeyHiveType.getType(typeManager, coercionContext.timestampPrecision())), valueCoercer.map(TypeCoercer::getFromType).orElseGet(() -> fromValueHiveType.getType(typeManager, coercionContext.timestampPrecision())), typeManager.getTypeOperators());
        MapType toType = new MapType(keyCoercer.map(TypeCoercer::getToType).orElseGet(() -> toKeyHiveType.getType(typeManager, coercionContext.timestampPrecision())), valueCoercer.map(TypeCoercer::getToType).orElseGet(() -> toValueHiveType.getType(typeManager, coercionContext.timestampPrecision())), typeManager.getTypeOperators());
        return Optional.of(new MapCoercer(fromType, toType, keyCoercer, valueCoercer));
    }

    private static Optional<TypeCoercer<? extends Type, ? extends Type>> createCoercerForStruct(TypeManager typeManager, StructTypeInfo fromStructTypeInfo, StructTypeInfo toStructTypeInfo, CoercionContext coercionContext) {
        ImmutableList.Builder coercers = ImmutableList.builder();
        ImmutableList.Builder fromField = ImmutableList.builder();
        ImmutableList.Builder toField = ImmutableList.builder();
        List<String> fromStructFieldName = fromStructTypeInfo.getAllStructFieldNames();
        List<String> toStructFieldNames = toStructTypeInfo.getAllStructFieldNames();
        for (int i = 0; i < toStructFieldNames.size(); ++i) {
            HiveType toStructFieldType = HiveType.valueOf(toStructTypeInfo.getAllStructFieldTypeInfos().get(i).getTypeName());
            if (i >= fromStructFieldName.size()) {
                toField.add((Object)new RowType.Field(Optional.of(toStructFieldNames.get(i)), toStructFieldType.getType(typeManager, coercionContext.timestampPrecision())));
                coercers.add(Optional.empty());
                continue;
            }
            HiveType fromStructFieldType = HiveType.valueOf(fromStructTypeInfo.getAllStructFieldTypeInfos().get(i).getTypeName());
            Optional<TypeCoercer<? extends Type, ? extends Type>> coercer = CoercionUtils.createCoercer(typeManager, fromStructFieldType, toStructFieldType, coercionContext);
            fromField.add((Object)new RowType.Field(Optional.of(fromStructFieldName.get(i)), coercer.map(TypeCoercer::getFromType).orElseGet(() -> fromStructFieldType.getType(typeManager, coercionContext.timestampPrecision()))));
            toField.add((Object)new RowType.Field(Optional.of(toStructFieldNames.get(i)), coercer.map(TypeCoercer::getToType).orElseGet(() -> toStructFieldType.getType(typeManager, coercionContext.timestampPrecision()))));
            coercers.add(coercer);
        }
        return Optional.of(new StructCoercer(RowType.from((List)fromField.build()), RowType.from((List)toField.build()), (List<Optional<TypeCoercer<? extends Type, ? extends Type>>>)coercers.build()));
    }

    public record CoercionContext(HiveTimestampPrecision timestampPrecision, boolean treatNaNAsNull) {
        public CoercionContext {
            Objects.requireNonNull(timestampPrecision, "timestampPrecision is null");
        }
    }

    private static class MapCoercer
    extends TypeCoercer<MapType, MapType> {
        private final Optional<TypeCoercer<? extends Type, ? extends Type>> keyCoercer;
        private final Optional<TypeCoercer<? extends Type, ? extends Type>> valueCoercer;

        public MapCoercer(MapType fromType, MapType toType, Optional<TypeCoercer<? extends Type, ? extends Type>> keyCoercer, Optional<TypeCoercer<? extends Type, ? extends Type>> valueCoercer) {
            super(fromType, toType);
            this.keyCoercer = Objects.requireNonNull(keyCoercer, "keyCoercer is null");
            this.valueCoercer = Objects.requireNonNull(valueCoercer, "valueCoercer is null");
        }

        @Override
        public Block apply(Block block) {
            ColumnarMap mapBlock = ColumnarMap.toColumnarMap((Block)block);
            Block keysBlock = this.keyCoercer.isEmpty() ? mapBlock.getKeysBlock() : this.keyCoercer.get().apply(mapBlock.getKeysBlock());
            Block valuesBlock = this.valueCoercer.isEmpty() ? mapBlock.getValuesBlock() : this.valueCoercer.get().apply(mapBlock.getValuesBlock());
            boolean[] valueIsNull = new boolean[mapBlock.getPositionCount()];
            int[] offsets = new int[mapBlock.getPositionCount() + 1];
            for (int i = 0; i < mapBlock.getPositionCount(); ++i) {
                valueIsNull[i] = mapBlock.isNull(i);
                offsets[i + 1] = offsets[i] + mapBlock.getEntryCount(i);
            }
            return ((MapType)this.toType).createBlockFromKeyValue(Optional.of(valueIsNull), offsets, keysBlock, valuesBlock);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private static class StructCoercer
    extends TypeCoercer<RowType, RowType> {
        private final List<Optional<TypeCoercer<? extends Type, ? extends Type>>> coercers;
        private final Block[] nullBlocks;

        public StructCoercer(RowType fromType, RowType toType, List<Optional<TypeCoercer<? extends Type, ? extends Type>>> coercers) {
            super(fromType, toType);
            this.coercers = ImmutableList.copyOf((Collection)Objects.requireNonNull(coercers, "coercers is null"));
            List toTypeFields = toType.getFields();
            this.nullBlocks = new Block[toTypeFields.size()];
            for (int i = 0; i < toTypeFields.size(); ++i) {
                if (i < fromType.getFields().size()) continue;
                this.nullBlocks[i] = ((RowType.Field)toTypeFields.get(i)).getType().createBlockBuilder(null, 1).appendNull().build();
            }
        }

        @Override
        public Block apply(Block block) {
            ColumnarRow rowBlock = ColumnarRow.toColumnarRow((Block)block);
            Block[] fields = new Block[this.coercers.size()];
            int[] ids = new int[rowBlock.getField(0).getPositionCount()];
            for (int i = 0; i < this.coercers.size(); ++i) {
                Optional<TypeCoercer<? extends Type, ? extends Type>> coercer = this.coercers.get(i);
                fields[i] = coercer.isPresent() ? coercer.get().apply(rowBlock.getField(i)) : (i < rowBlock.getFieldCount() ? rowBlock.getField(i) : DictionaryBlock.create((int)ids.length, (Block)this.nullBlocks[i], (int[])ids));
            }
            boolean[] valueIsNull = null;
            if (rowBlock.mayHaveNull()) {
                valueIsNull = new boolean[rowBlock.getPositionCount()];
                for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                    valueIsNull[i] = rowBlock.isNull(i);
                }
            }
            return RowBlock.fromFieldBlocks((int)rowBlock.getPositionCount(), Optional.ofNullable(valueIsNull), (Block[])fields);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private static class ListCoercer
    extends TypeCoercer<ArrayType, ArrayType> {
        private final TypeCoercer<? extends Type, ? extends Type> elementCoercer;

        public ListCoercer(ArrayType fromType, ArrayType toType, TypeCoercer<? extends Type, ? extends Type> elementCoercer) {
            super(fromType, toType);
            this.elementCoercer = Objects.requireNonNull(elementCoercer, "elementCoercer is null");
        }

        @Override
        public Block apply(Block block) {
            ColumnarArray arrayBlock = ColumnarArray.toColumnarArray((Block)block);
            Block elementsBlock = this.elementCoercer.apply(arrayBlock.getElementsBlock());
            boolean[] valueIsNull = new boolean[arrayBlock.getPositionCount()];
            int[] offsets = new int[arrayBlock.getPositionCount() + 1];
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                valueIsNull[i] = arrayBlock.isNull(i);
                offsets[i + 1] = offsets[i] + arrayBlock.getLength(i);
            }
            return ArrayBlock.fromElementBlock((int)arrayBlock.getPositionCount(), Optional.of(valueIsNull), (int[])offsets, (Block)elementsBlock);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

