/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.stream;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.orc.OrcOutputBuffer;
import io.trino.orc.checkpoint.DecimalStreamCheckpoint;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.Stream;
import io.trino.orc.stream.LongDecode;
import io.trino.orc.stream.StreamDataOutput;
import io.trino.orc.stream.ValueOutputStream;
import io.trino.spi.type.Int128;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class DecimalOutputStream
implements ValueOutputStream<DecimalStreamCheckpoint> {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DecimalOutputStream.class);
    private final OrcOutputBuffer buffer;
    private final List<DecimalStreamCheckpoint> checkpoints = new ArrayList<DecimalStreamCheckpoint>();
    private boolean closed;

    public DecimalOutputStream(CompressionKind compression, int bufferSize) {
        this.buffer = new OrcOutputBuffer(compression, bufferSize);
    }

    public void writeUnscaledValue(Int128 decimal) {
        BigInteger value = decimal.toBigInteger();
        int sign = (value = value.shiftLeft(1)).signum();
        if (sign < 0) {
            value = value.negate();
            value = value.subtract(BigInteger.ONE);
        }
        int length = value.bitLength();
        while (true) {
            long lowBits = value.longValue() & Long.MAX_VALUE;
            length -= 63;
            for (int i = 0; i < 9; ++i) {
                if (length <= 0 && (lowBits & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    this.buffer.write((byte)lowBits);
                    return;
                }
                this.buffer.write((byte)(0x80L | lowBits & 0x7FL));
                lowBits >>>= 7;
            }
            value = value.shiftRight(63);
        }
    }

    public void writeUnscaledValue(long value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        LongDecode.writeVLong(this.buffer, value, true);
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkpoints.add(new DecimalStreamCheckpoint(this.buffer.getCheckpoint()));
    }

    @Override
    public void close() {
        this.closed = true;
        this.buffer.close();
    }

    @Override
    public List<DecimalStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.copyOf(this.checkpoints);
    }

    @Override
    public StreamDataOutput getStreamDataOutput(OrcColumnId columnId) {
        return new StreamDataOutput(this.buffer::writeDataTo, new Stream(columnId, Stream.StreamKind.DATA, Math.toIntExact(this.buffer.getOutputDataSize()), true));
    }

    @Override
    public long getBufferedBytes() {
        return this.buffer.estimateOutputDataSize();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.buffer.getRetainedSize();
    }

    @Override
    public void reset() {
        this.closed = false;
        this.buffer.reset();
        this.checkpoints.clear();
    }
}

