/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.common.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.spi.CacheConfig;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class BookKeeperMetricsFilter
implements MetricFilter {
    private final List<String> whitelist;

    public BookKeeperMetricsFilter(Configuration conf) {
        this.whitelist = this.createWhitelist(conf);
    }

    private List<String> createWhitelist(Configuration conf) {
        ArrayList<String> whitelist = new ArrayList<String>();
        if (CacheConfig.areHealthMetricsEnabled(conf)) {
            whitelist.addAll(BookKeeperMetrics.HealthMetric.getAllNames());
        }
        if (CacheConfig.areCacheMetricsEnabled(conf)) {
            whitelist.addAll(BookKeeperMetrics.CacheMetric.getAllNames());
        }
        if (CacheConfig.areJvmMetricsEnabled(conf)) {
            whitelist.addAll(BookKeeperMetrics.BookKeeperJvmMetric.getAllNames());
            whitelist.addAll(BookKeeperMetrics.LDTSJvmMetric.getAllNames());
        }
        if (CacheConfig.isValidationEnabled(conf)) {
            whitelist.addAll(BookKeeperMetrics.ValidationMetric.getAllNames());
        }
        return whitelist;
    }

    @Override
    public boolean matches(String name, Metric metric) {
        for (String whitelistedMetric : this.whitelist) {
            if (!name.startsWith(whitelistedMetric)) continue;
            return true;
        }
        return false;
    }
}

