/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.RetryingPooledBookkeeperClient;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class RemoteFetchRequestChain
extends ReadRequestChain {
    private static final Log log = LogFactory.getLog(RemoteFetchRequestChain.class);
    String remotePath;
    FileSystem remoteFileSystem;
    String remoteNodeLocation;
    Configuration conf;
    BookKeeperFactory bookKeeperFactory;
    long lastModified;
    long fileSize;
    int clusterType;

    public RemoteFetchRequestChain(String remotePath, FileSystem remoteFileSystem, String remoteNodeLocation, Configuration conf, long lastModified, long fileSize, int clusterType, BookKeeperFactory bookKeeperFactory) {
        super(0);
        this.remotePath = remotePath;
        this.remoteFileSystem = remoteFileSystem;
        this.remoteNodeLocation = remoteNodeLocation;
        this.conf = conf;
        this.lastModified = lastModified;
        this.fileSize = fileSize;
        this.clusterType = clusterType;
        this.bookKeeperFactory = bookKeeperFactory;
    }

    @Override
    public Long call() throws Exception {
        if (this.readRequests.size() == 0) {
            return 0L;
        }
        long startTime = System.currentTimeMillis();
        try (RetryingPooledBookkeeperClient client = this.bookKeeperFactory.createBookKeeperClient(this.remoteNodeLocation, this.conf);){
            for (ReadRequest request : this.readRequests) {
                log.debug((Object)("RemoteFetchRequest from : " + this.remoteNodeLocation + " Start : " + request.backendReadStart + " of length " + request.getBackendReadLengthIntUnsafe()));
                client.readData(this.remotePath, request.backendReadStart, request.getBackendReadLengthIntUnsafe(), this.fileSize, this.lastModified, this.clusterType);
            }
        }
        catch (Exception e) {
            log.info((Object)("Could not initiate parallel warmup in node " + this.remoteNodeLocation), (Throwable)e);
            throw e;
        }
        log.debug((Object)("Send request to remote took " + (System.currentTimeMillis() - startTime) + " :msecs"));
        return 0L;
    }

    @Override
    public ReadRequestChainStats getStats() {
        return new ReadRequestChainStats();
    }

    @Override
    public void updateCacheStatus(String remotePath, long fileSize, long lastModified, int blockSize, Configuration conf) {
        if (CacheConfig.isDummyModeEnabled(conf)) {
            try (RetryingPooledBookkeeperClient bookKeeperClient = this.bookKeeperFactory.createBookKeeperClient(this.remoteNodeLocation, conf);){
                for (ReadRequest readRequest : this.readRequests) {
                    long startBlock = this.toBlock(readRequest.getBackendReadStart());
                    long endBlock = this.toBlock(readRequest.getBackendReadEnd() - 1L) + 1L;
                    CacheStatusRequest request = new CacheStatusRequest(remotePath, fileSize, lastModified, startBlock, endBlock).setClusterType(this.clusterType);
                    bookKeeperClient.getCacheStatus(request);
                    bookKeeperClient.setAllCached(remotePath, fileSize, lastModified, startBlock, endBlock, 1);
                }
            }
            catch (Exception e) {
                log.error((Object)"Dummy Mode: Could not update Cache Status for Remote Fetch Request ", (Throwable)e);
            }
        }
    }

    private long toBlock(long pos) {
        long blockSize = CacheConfig.getBlockSize(this.conf);
        return pos / blockSize;
    }
}

