/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.thrift.transport;

public class AutoExpandingBuffer {
    private byte[] array;
    private final double growthCoefficient;

    public AutoExpandingBuffer(int initialCapacity, double growthCoefficient) {
        if (growthCoefficient < 1.0) {
            throw new IllegalArgumentException("Growth coefficient must be >= 1.0");
        }
        this.array = new byte[initialCapacity];
        this.growthCoefficient = growthCoefficient;
    }

    public void resizeIfNecessary(int size) {
        if (this.array.length < size) {
            byte[] newBuf = new byte[(int)((double)size * this.growthCoefficient)];
            System.arraycopy(this.array, 0, newBuf, 0, this.array.length);
            this.array = newBuf;
        }
    }

    public byte[] array() {
        return this.array;
    }
}

