/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.linkedin.coral.calcite.$internal.com.google.common.base.Preconditions;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.common.HiveTable;
import com.linkedin.coral.common.functions.Function;
import com.linkedin.coral.common.functions.FunctionRegistry;
import com.linkedin.coral.common.functions.UnknownSqlFunctionException;
import com.linkedin.coral.hive.hive2rel.functions.HiveGenericUDFReturnTypeInference;
import com.linkedin.coral.hive.hive2rel.functions.HiveRLikeOperator;
import com.linkedin.coral.hive.hive2rel.functions.VersionedSqlUserDefinedFunction;
import com.linkedin.coral.hive.metastore.api.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;

public class HiveFunctionResolver {
    public final FunctionRegistry registry;
    private final ConcurrentHashMap<String, Function> dynamicFunctionRegistry;
    private final List<SqlOperator> operators;

    public HiveFunctionResolver(FunctionRegistry registry, ConcurrentHashMap<String, Function> dynamicRegistry) {
        this.registry = registry;
        this.dynamicFunctionRegistry = dynamicRegistry;
        this.operators = new ArrayList<SqlOperator>(SqlStdOperatorTable.instance().getOperatorList());
        this.operators.add(HiveRLikeOperator.REGEXP);
        this.operators.add(HiveRLikeOperator.RLIKE);
    }

    public SqlOperator resolveUnaryOperator(String name) {
        if ("!".equals(name)) {
            return SqlStdOperatorTable.NOT;
        }
        List matches = this.operators.stream().filter(o -> o.getName().equalsIgnoreCase(name) && o instanceof SqlPrefixOperator).collect(Collectors.toList());
        com.google.common.base.Preconditions.checkState((matches.size() == 1 ? 1 : 0) != 0, (String)"%s operator %s", (Object[])new Object[]{matches.isEmpty() ? "Unknown" : "Ambiguous", name});
        return (SqlOperator)matches.get(0);
    }

    public SqlOperator resolveBinaryOperator(String name) {
        Function f;
        String lowerCaseOperator = name.toLowerCase();
        List matches = this.operators.stream().filter(o -> o.getName().toLowerCase().equals(lowerCaseOperator) && (o instanceof SqlBinaryOperator || o instanceof SqlSpecialOperator)).collect(Collectors.toList());
        if (matches.size() == 0 && (f = this.tryResolve(lowerCaseOperator, null, 2)) != null) {
            matches.add(f.getSqlOperator());
        }
        if (lowerCaseOperator.equals("+")) {
            return SqlStdOperatorTable.PLUS;
        }
        if (lowerCaseOperator.equals("-")) {
            return SqlStdOperatorTable.MINUS;
        }
        com.google.common.base.Preconditions.checkState((matches.size() == 1 ? 1 : 0) != 0, (String)"%s operator %s", (Object[])new Object[]{this.operators.isEmpty() ? "Unknown" : "Ambiguous", name});
        return (SqlOperator)matches.get(0);
    }

    public Function tryResolve(@Nonnull String functionName, @Nullable Table hiveTable, int numOfOperands) {
        com.google.common.base.Preconditions.checkNotNull((Object)functionName);
        Collection<Function> functions = this.registry.lookup(functionName);
        if (functions.isEmpty() && hiveTable != null) {
            functions = this.tryResolveAsDaliFunction(functionName, hiveTable, numOfOperands);
        }
        if (functions.isEmpty()) {
            throw new UnknownSqlFunctionException(functionName);
        }
        if (functions.size() == 1) {
            return functions.iterator().next();
        }
        return this.unresolvedFunction(functions.iterator().next().getSqlOperator().getName());
    }

    public Collection<Function> resolve(String functionName) {
        Collection<Function> staticLookup = this.registry.lookup(functionName);
        if (!staticLookup.isEmpty()) {
            return staticLookup;
        }
        ImmutableList<Function> dynamicLookup = ImmutableList.of();
        Function Function3 = this.dynamicFunctionRegistry.get(functionName);
        if (Function3 != null) {
            dynamicLookup = ImmutableList.of(Function3);
        }
        return dynamicLookup;
    }

    public Collection<Function> tryResolveAsDaliFunction(String functionName, @Nonnull Table table, int numOfOperands) {
        Preconditions.checkNotNull(table);
        String functionPrefix = String.format("%s_%s_", table.getDbName(), table.getTableName());
        if (!functionName.toLowerCase().startsWith(functionPrefix.toLowerCase())) {
            return ImmutableList.of();
        }
        String funcBaseName = functionName.substring(functionPrefix.length());
        HiveTable hiveTable = new HiveTable(table);
        Map<String, String> functionParams = hiveTable.getDaliFunctionParams();
        String funcClassName = functionParams.get(funcBaseName);
        if (funcClassName == null) {
            return ImmutableList.of();
        }
        Collection<Function> Functions2 = this.registry.lookup(funcClassName);
        if (Functions2.size() == 0) {
            Collection<Function> dynamicResolvedFunctions = this.resolveDaliFunctionDynamically(functionName, funcClassName, hiveTable, numOfOperands);
            if (dynamicResolvedFunctions.size() == 0) {
                throw new UnknownSqlFunctionException(funcClassName);
            }
            return dynamicResolvedFunctions;
        }
        return Functions2.stream().map(f -> new Function(f.getFunctionName(), new VersionedSqlUserDefinedFunction((SqlUserDefinedFunction)f.getSqlOperator(), hiveTable.getDaliUdfDependencies(), functionName))).collect(Collectors.toList());
    }

    @Nonnull
    private Collection<Function> resolveDaliFunctionDynamically(String functionName, String funcClassName, HiveTable hiveTable, int numOfOperands) {
        if (this.dynamicFunctionRegistry.contains(funcClassName)) {
            return ImmutableList.of(this.dynamicFunctionRegistry.get(functionName));
        }
        Function function = new Function(funcClassName, new VersionedSqlUserDefinedFunction(new SqlUserDefinedFunction(new SqlIdentifier(funcClassName, SqlParserPos.ZERO), (SqlReturnTypeInference)new HiveGenericUDFReturnTypeInference(funcClassName, hiveTable.getDaliUdfDependencies()), null, this.createSqlOperandTypeChecker(numOfOperands), null, null), hiveTable.getDaliUdfDependencies(), functionName));
        this.dynamicFunctionRegistry.put(funcClassName, function);
        return ImmutableList.of(function);
    }

    @Nonnull
    private Function unresolvedFunction(String functionName) {
        SqlIdentifier funcIdentifier = new SqlIdentifier(ImmutableList.of(functionName), SqlParserPos.ZERO);
        return new Function(functionName, new SqlUnresolvedFunction(funcIdentifier, null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION));
    }

    @Nonnull
    private SqlOperandTypeChecker createSqlOperandTypeChecker(int numOfOperands) {
        ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
        for (int i = 0; i < numOfOperands; ++i) {
            families.add(SqlTypeFamily.ANY);
        }
        FamilyOperandTypeChecker sqlOperandTypeChecker = OperandTypes.family(families);
        return sqlOperandTypeChecker;
    }
}

