/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import com.linkedin.coral.common.TypeConverter;
import com.linkedin.coral.hive.hive2rel.functions.ArtifactsResolver;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlReturnTypeInference;

public class HiveGenericUDFReturnTypeInference
implements SqlReturnTypeInference {
    private final String _udfClassName;
    private final List<String> _udfDependencies;
    private final ArtifactsResolver _artifactsResolver;
    private URLClassLoader _udfClassLoader = null;

    public HiveGenericUDFReturnTypeInference(String udfClassName, List<String> udfDependencies) {
        this._udfClassName = udfClassName;
        this._udfDependencies = udfDependencies;
        this._artifactsResolver = new ArtifactsResolver();
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding sqlOperatorBinding) {
        int operandCount = sqlOperatorBinding.getOperandCount();
        ObjectInspector[] inputObjectInspectors = new ObjectInspector[operandCount];
        for (int i = 0; i < operandCount; ++i) {
            inputObjectInspectors[i] = this.getObjectInspector(sqlOperatorBinding.getOperandType(i));
        }
        return this.inferReturnType(inputObjectInspectors, sqlOperatorBinding.getTypeFactory());
    }

    public RelDataType inferReturnType(ObjectInspector[] inputObjectInspectors, RelDataTypeFactory relDataTypeFactory) {
        try {
            Class dynamicallyLoadedUdfClass = this.getDynamicallyLoadedUdfClass();
            Method initializeMethod = dynamicallyLoadedUdfClass.getMethod("initialize", this.getDynamicallyLoadedObjectInspectorArrayClass());
            Object oi = initializeMethod.invoke(dynamicallyLoadedUdfClass.newInstance(), this.getDynamicallyLoadedObjectInspectors(inputObjectInspectors));
            return this.getRelDataType(this.getContextObjectInspector(oi), relDataTypeFactory);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find org.apache.hadoop.hive.ql.udf.generic.GenericUDF.initialize() on: " + this._udfClassName, e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate a new instance of " + this._udfClassName, e);
        }
        catch (IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Unable to call org.apache.hadoop.hive.ql.udf.generic.GenericUDF.initialize() on: " + this._udfClassName, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class  " + this._udfClassName, e);
        }
    }

    private ObjectInspector getObjectInspector(RelDataType relDataType) {
        TypeInfo typeInfo = TypeConverter.convert(relDataType);
        return TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(typeInfo);
    }

    private RelDataType getRelDataType(ObjectInspector hiveObjectInspector, RelDataTypeFactory relDataTypeFactory) {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(hiveObjectInspector);
        return TypeConverter.convert(typeInfo, relDataTypeFactory);
    }

    private URLClassLoader getUdfClassLoader() {
        if (this._udfClassLoader == null) {
            URL[] urls = (URL[])this._udfDependencies.stream().flatMap(udfDependency -> this._artifactsResolver.resolve(this._udfClassName, (String)udfDependency).stream()).map(file -> HiveGenericUDFReturnTypeInference.url(file.toURI())).toArray(URL[]::new);
            this._udfClassLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
        }
        return this._udfClassLoader;
    }

    private Class getDynamicallyLoadedUdfClass() throws ClassNotFoundException {
        try {
            return Class.forName(this._udfClassName, true, this.getUdfClassLoader());
        }
        catch (NoClassDefFoundError error) {
            if (error.getMessage().contains("GenericUDF")) {
                this._udfClassLoader = null;
                this._udfDependencies.add("org.apache.hive:hive-exec:1.1.0");
                return Class.forName(this._udfClassName, true, this.getUdfClassLoader());
            }
            throw error;
        }
    }

    private Class getDynamicallyLoadedObjectInspectorArrayClass() throws ClassNotFoundException {
        return Class.forName("[Lcom.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;", true, this.getUdfClassLoader());
    }

    private Object getDynamicallyLoadedObjectInspectors(ObjectInspector[] ois) {
        try {
            Class<?> objectInspectorClass = Class.forName("com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector", true, this.getUdfClassLoader());
            Object objectInspectorArray = Array.newInstance(objectInspectorClass, ois.length);
            for (int i = 0; i < ois.length; ++i) {
                Array.set(objectInspectorArray, i, this.getDynamicallyLoadedObjectInspector(TypeInfoUtils.getTypeInfoFromObjectInspector(ois[i]).getQualifiedName()));
            }
            return objectInspectorArray;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not get UDF ObjectInspector from context class loader ObjectInspector.", e);
        }
    }

    private Object getDynamicallyLoadedObjectInspector(String typeName) {
        try {
            Class<?> typeInfoUtilsClass = Class.forName("com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils", true, this.getUdfClassLoader());
            Class<?> typeInfoClass = Class.forName("com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TypeInfo", true, this.getUdfClassLoader());
            Object typeInfo = typeInfoUtilsClass.getMethod("getTypeInfoFromTypeString", String.class).invoke(null, typeName);
            return typeInfoUtilsClass.getMethod("getStandardJavaObjectInspectorFromTypeInfo", typeInfoClass).invoke(null, typeInfo);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not get UDF ObjectInspector from String type name.", e);
        }
    }

    private ObjectInspector getContextObjectInspector(Object oi) {
        try {
            Class<?> objectInspectorClass = Class.forName("com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector", true, this.getUdfClassLoader());
            Class<?> typeInfoUtilsClass = Class.forName("com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils", true, this.getUdfClassLoader());
            Class<?> typeInfoClass = Class.forName("com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TypeInfo", true, this.getUdfClassLoader());
            Object typeInfo = typeInfoUtilsClass.getMethod("getTypeInfoFromObjectInspector", objectInspectorClass).invoke(null, oi);
            String typeInfoString = (String)typeInfoClass.getMethod("getQualifiedName", new Class[0]).invoke(typeInfo, new Object[0]);
            return TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(TypeInfoUtils.getTypeInfoFromTypeString(typeInfoString));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not get Context ObjectInspector from dynamically loaded ObjectInspector.", e);
        }
    }

    private static URL url(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + uri, e);
        }
    }
}

