/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.linkedin.coral.calcite.;
import com.linkedin.coral.calcite.$internal.com.google.common.base.Function;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableSortedMap;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.Iterables;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.Ordering;
import java.io.Serializable;
import java.nio.LongBuffer;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableIntList;

public class ImmutableBitSet
implements Iterable<Integer>,
Serializable,
Comparable<ImmutableBitSet> {
    public static final Comparator<ImmutableBitSet> COMPARATOR = (o1, o2) -> {
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1.contains((ImmutableBitSet)o2)) {
            return -1;
        }
        if (o2.contains((ImmutableBitSet)o1)) {
            return 1;
        }
        return o1.compareTo((ImmutableBitSet)o2);
    };
    public static final Ordering<ImmutableBitSet> ORDERING = Ordering.from(COMPARATOR);
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;
    private static final long[] EMPTY_LONGS = new long[0];
    private static final ImmutableBitSet EMPTY = new ImmutableBitSet(EMPTY_LONGS);
    @Deprecated
    public static final Function<? super BitSet, ImmutableBitSet> FROM_BIT_SET = ImmutableBitSet::fromBitSet;
    private final long[] words;

    private ImmutableBitSet(long[] words) {
        this.words = words;
        assert (words.length != 0 ? words[words.length - 1] != 0L : words == EMPTY_LONGS);
    }

    public static ImmutableBitSet of() {
        return EMPTY;
    }

    public static ImmutableBitSet of(int ... bits) {
        int max = -1;
        for (int bit : bits) {
            max = Math.max(bit, max);
        }
        if (max == -1) {
            return EMPTY;
        }
        long[] words = new long[ImmutableBitSet.wordIndex(max) + 1];
        for (int bit : bits) {
            int wordIndex;
            int n = wordIndex = ImmutableBitSet.wordIndex(bit);
            words[n] = words[n] | 1L << bit;
        }
        return new ImmutableBitSet(words);
    }

    public static ImmutableBitSet of(Iterable<Integer> bits) {
        if (bits instanceof ImmutableBitSet) {
            return (ImmutableBitSet)bits;
        }
        int max = -1;
        for (int bit : bits) {
            max = Math.max(bit, max);
        }
        if (max == -1) {
            return EMPTY;
        }
        long[] words = new long[ImmutableBitSet.wordIndex(max) + 1];
        for (int bit : bits) {
            int wordIndex;
            int n = wordIndex = ImmutableBitSet.wordIndex(bit);
            words[n] = words[n] | 1L << bit;
        }
        return new ImmutableBitSet(words);
    }

    public static ImmutableBitSet of(ImmutableIntList bits) {
        return ImmutableBitSet.builder().addAll(bits).build();
    }

    public static ImmutableBitSet valueOf(long ... longs) {
        int n;
        for (n = longs.length; n > 0 && longs[n - 1] == 0L; --n) {
        }
        if (n == 0) {
            return EMPTY;
        }
        return new ImmutableBitSet(Arrays.copyOf(longs, n));
    }

    public static ImmutableBitSet valueOf(LongBuffer longs) {
        int n;
        longs = longs.slice();
        for (n = longs.remaining(); n > 0 && longs.get(n - 1) == 0L; --n) {
        }
        if (n == 0) {
            return EMPTY;
        }
        long[] words = new long[n];
        longs.get(words);
        return new ImmutableBitSet(words);
    }

    public static ImmutableBitSet fromBitSet(BitSet input) {
        return ImmutableBitSet.of(BitSets.toIter(input));
    }

    public static ImmutableBitSet range(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (toIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        int startWordIndex = ImmutableBitSet.wordIndex(fromIndex);
        int endWordIndex = ImmutableBitSet.wordIndex(toIndex - 1);
        long[] words = new long[endWordIndex + 1];
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            words[n] = words[n] | firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            words[n] = words[n] | firstWordMask;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                words[i] = -1L;
            }
            int n2 = endWordIndex;
            words[n2] = words[n2] | lastWordMask;
        }
        return new ImmutableBitSet(words);
    }

    public static ImmutableBitSet range(int toIndex) {
        return ImmutableBitSet.range(0, toIndex);
    }

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    public Iterable<ImmutableBitSet> powerSet() {
        ArrayList<ImmutableList<ImmutableBitSet>> singletons = new ArrayList<ImmutableList<ImmutableBitSet>>();
        for (int bit : this) {
            singletons.add(ImmutableList.of(ImmutableBitSet.of(), ImmutableBitSet.of(bit)));
        }
        return Iterables.transform(Linq4j.product(singletons), ImmutableBitSet::union);
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = ImmutableBitSet.wordIndex(bitIndex);
        return wordIndex < this.words.length && (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    public ImmutableBitSet get(int fromIndex, int toIndex) {
        ImmutableBitSet.checkRange(fromIndex, toIndex);
        Builder builder = ImmutableBitSet.builder();
        int i = this.nextSetBit(fromIndex);
        while (i >= 0 && i < toIndex) {
            builder.set(i);
            i = this.nextSetBit(i + 1);
        }
        return builder.build();
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    public String toString() {
        int numBits = this.words.length * 64;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            i = this.nextSetBit(i + 1);
            while (i >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i < endOfRun);
                i = this.nextSetBit(i + 1);
            }
        }
        b.append('}');
        return b.toString();
    }

    public boolean intersects(ImmutableBitSet set) {
        for (int i = Math.min(this.words.length, set.words.length) - 1; i >= 0; --i) {
            if ((this.words[i] & set.words[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        return ImmutableBitSet.countBits(this.words);
    }

    private static int countBits(long[] words) {
        int sum = 0;
        for (long word : words) {
            sum += Long.bitCount(word);
        }
        return sum;
    }

    public int hashCode() {
        long h2 = 1234L;
        int i = this.words.length;
        while (--i >= 0) {
            h2 ^= this.words[i] * (long)(i + 1);
        }
        return (int)(h2 >> 32 ^ h2);
    }

    public int size() {
        return this.words.length * 64;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImmutableBitSet)) {
            return false;
        }
        ImmutableBitSet set = (ImmutableBitSet)obj;
        return Arrays.equals(this.words, set.words);
    }

    @Override
    public int compareTo(@.Nonnull ImmutableBitSet o) {
        int i = 0;
        int n1;
        int n0;
        int c;
        while ((c = Utilities.compare(n0 = this.nextSetBit(i), n1 = o.nextSetBit(i))) == 0 && n0 >= 0) {
            i = n0 + 1;
        }
        return c;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u = ImmutableBitSet.wordIndex(fromIndex);
        if (u >= this.words.length) {
            return -1;
        }
        long word = this.words[u] & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.words.length) {
                return -1;
            }
            word = this.words[u];
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u = ImmutableBitSet.wordIndex(fromIndex);
        if (u >= this.words.length) {
            return fromIndex;
        }
        long word = (this.words[u] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.words.length) {
                return this.words.length * 64;
            }
            word = this.words[u] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int previousClearBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        int u = ImmutableBitSet.wordIndex(fromIndex);
        if (u >= this.words.length) {
            return fromIndex;
        }
        long word = (this.words[u] ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (u + 1) * 64 - 1 - Long.numberOfLeadingZeros(word);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int i;
            {
                this.i = ImmutableBitSet.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public Integer next() {
                int prev = this.i;
                this.i = ImmutableBitSet.this.nextSetBit(this.i + 1);
                return prev;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List<Integer> toList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = this.nextSetBit(0);
        while (i >= 0) {
            list.add(i);
            i = this.nextSetBit(i + 1);
        }
        return list;
    }

    public List<Integer> asList() {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return ImmutableBitSet.this.nth(index);
            }

            @Override
            public int size() {
                return ImmutableBitSet.this.cardinality();
            }

            @Override
            @.Nonnull
            public Iterator<Integer> iterator() {
                return ImmutableBitSet.this.iterator();
            }
        };
    }

    public Set<Integer> asSet() {
        return new AbstractSet<Integer>(){

            @Override
            @.Nonnull
            public Iterator<Integer> iterator() {
                return ImmutableBitSet.this.iterator();
            }

            @Override
            public int size() {
                return ImmutableBitSet.this.cardinality();
            }

            @Override
            public boolean contains(Object o) {
                return ImmutableBitSet.this.get((Integer)o);
            }
        };
    }

    public int[] toArray() {
        int[] integers = new int[this.cardinality()];
        int j = 0;
        int i = this.nextSetBit(0);
        while (i >= 0) {
            integers[j++] = i;
            i = this.nextSetBit(i + 1);
        }
        return integers;
    }

    public long[] toLongArray() {
        return this.words.length == 0 ? this.words : (long[])this.words.clone();
    }

    public ImmutableBitSet union(BitSet other) {
        return this.rebuild().addAll(BitSets.toIter(other)).build();
    }

    public ImmutableBitSet union(ImmutableBitSet other) {
        return this.rebuild().addAll(other).build(other);
    }

    public static ImmutableBitSet union(Iterable<? extends ImmutableBitSet> sets) {
        Builder builder = ImmutableBitSet.builder();
        for (ImmutableBitSet immutableBitSet : sets) {
            builder.addAll(immutableBitSet);
        }
        return builder.build();
    }

    public ImmutableBitSet except(ImmutableBitSet that) {
        Builder builder = this.rebuild();
        builder.removeAll(that);
        return builder.build();
    }

    public ImmutableBitSet intersect(ImmutableBitSet that) {
        Builder builder = this.rebuild();
        builder.intersect(that);
        return builder.build();
    }

    public boolean contains(ImmutableBitSet set1) {
        int i = set1.nextSetBit(0);
        while (i >= 0) {
            if (!this.get(i)) {
                return false;
            }
            i = set1.nextSetBit(i + 1);
        }
        return true;
    }

    public int indexOf(int bit) {
        int i = this.nextSetBit(0);
        int k = 0;
        while (i >= 0) {
            if (i == bit) {
                return k;
            }
            i = this.nextSetBit(i + 1);
            ++k;
        }
        return -1;
    }

    public static SortedMap<Integer, ImmutableBitSet> closure(SortedMap<Integer, ImmutableBitSet> equivalence) {
        if (equivalence.isEmpty()) {
            return ImmutableSortedMap.of();
        }
        int length = equivalence.lastKey();
        for (ImmutableBitSet bitSet : equivalence.values()) {
            length = Math.max(length, bitSet.length());
        }
        if (equivalence.size() < length || equivalence.firstKey() != 0) {
            SortedMap<Integer, ImmutableBitSet> old = equivalence;
            equivalence = new TreeMap<Integer, ImmutableBitSet>();
            for (int i = 0; i < length; ++i) {
                ImmutableBitSet bitSet = (ImmutableBitSet)old.get(i);
                equivalence.put(i, bitSet == null ? ImmutableBitSet.of() : bitSet);
            }
        }
        Closure closure = new Closure(equivalence);
        return closure.closure;
    }

    public int length() {
        if (this.words.length == 0) {
            return 0;
        }
        return 64 * (this.words.length - 1) + (64 - Long.numberOfLeadingZeros(this.words[this.words.length - 1]));
    }

    public boolean isEmpty() {
        return this.words.length == 0;
    }

    public static Builder builder() {
        return new Builder(EMPTY_LONGS);
    }

    @Deprecated
    public static Builder builder(ImmutableBitSet bitSet) {
        return bitSet.rebuild();
    }

    public Builder rebuild() {
        return new Rebuilder(this);
    }

    public int nth(int n) {
        int start = 0;
        for (long word : this.words) {
            int bitCount = Long.bitCount(word);
            if (n < bitCount) {
                while (word != 0L) {
                    if ((word & 1L) == 1L) {
                        if (n == 0) {
                            return start;
                        }
                        --n;
                    }
                    word >>= 1;
                    ++start;
                }
            }
            start += 64;
            n -= bitCount;
        }
        throw new IndexOutOfBoundsException("index out of range: " + n);
    }

    public ImmutableBitSet set(int i) {
        return this.union(ImmutableBitSet.of(i));
    }

    public ImmutableBitSet set(int i, boolean b) {
        if (this.get(i) == b) {
            return this;
        }
        return b ? this.set(i) : this.clear(i);
    }

    public ImmutableBitSet setIf(int bit, boolean condition) {
        return condition ? this.set(bit) : this;
    }

    public ImmutableBitSet clear(int i) {
        return this.except(ImmutableBitSet.of(i));
    }

    public ImmutableBitSet clearIf(int i, boolean condition) {
        return condition ? this.except(ImmutableBitSet.of(i)) : this;
    }

    public BitSet toBitSet() {
        return BitSets.of(this);
    }

    public ImmutableBitSet permute(Map<Integer, Integer> map) {
        Builder builder = ImmutableBitSet.builder();
        int i = this.nextSetBit(0);
        while (i >= 0) {
            builder.set(map.get(i));
            i = this.nextSetBit(i + 1);
        }
        return builder.build();
    }

    public static Iterable<ImmutableBitSet> permute(Iterable<ImmutableBitSet> bitSets, Map<Integer, Integer> map) {
        return Iterables.transform(bitSets, bitSet -> bitSet.permute(map));
    }

    public ImmutableBitSet shift(int offset) {
        if (offset == 0) {
            return this;
        }
        Builder builder = ImmutableBitSet.builder();
        int i = this.nextSetBit(0);
        while (i >= 0) {
            builder.set(i + offset);
            i = this.nextSetBit(i + 1);
        }
        return builder.build();
    }

    private static class Rebuilder
    extends Builder {
        private final ImmutableBitSet originalBitSet;

        private Rebuilder(ImmutableBitSet originalBitSet) {
            super((long[])originalBitSet.words.clone());
            this.originalBitSet = originalBitSet;
        }

        @Override
        public ImmutableBitSet build() {
            if (this.wouldEqual(this.originalBitSet)) {
                return this.originalBitSet;
            }
            return super.build();
        }

        @Override
        public ImmutableBitSet build(ImmutableBitSet bitSet) {
            if (this.wouldEqual(this.originalBitSet)) {
                return this.originalBitSet;
            }
            return super.build(bitSet);
        }
    }

    public static class Builder {
        private long[] words;

        private Builder(long[] words) {
            this.words = words;
        }

        public ImmutableBitSet build() {
            if (this.words == null) {
                throw new IllegalArgumentException("can only use builder once");
            }
            if (this.words.length == 0) {
                return EMPTY;
            }
            long[] words = this.words;
            this.words = null;
            return new ImmutableBitSet(words);
        }

        public ImmutableBitSet buildAndReset() {
            if (this.words == null) {
                throw new IllegalArgumentException("can only use builder once");
            }
            if (this.words.length == 0) {
                return EMPTY;
            }
            long[] words = this.words;
            this.words = EMPTY_LONGS;
            return new ImmutableBitSet(words);
        }

        public ImmutableBitSet build(ImmutableBitSet bitSet) {
            if (this.wouldEqual(bitSet)) {
                return bitSet;
            }
            return this.build();
        }

        public Builder set(int bit) {
            if (this.words == null) {
                throw new IllegalArgumentException("can only use builder once");
            }
            int wordIndex = ImmutableBitSet.wordIndex(bit);
            if (wordIndex >= this.words.length) {
                this.words = Arrays.copyOf(this.words, wordIndex + 1);
            }
            int n = wordIndex;
            this.words[n] = this.words[n] | 1L << bit;
            return this;
        }

        public boolean get(int bitIndex) {
            if (this.words == null) {
                throw new IllegalArgumentException("can only use builder once");
            }
            if (bitIndex < 0) {
                throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
            }
            int wordIndex = ImmutableBitSet.wordIndex(bitIndex);
            return wordIndex < this.words.length && (this.words[wordIndex] & 1L << bitIndex) != 0L;
        }

        private void trim(int wordCount) {
            while (wordCount > 0 && this.words[wordCount - 1] == 0L) {
                --wordCount;
            }
            if (wordCount == this.words.length) {
                return;
            }
            this.words = wordCount == 0 ? EMPTY_LONGS : Arrays.copyOfRange(this.words, 0, wordCount);
        }

        public Builder clear(int bit) {
            int wordIndex = ImmutableBitSet.wordIndex(bit);
            if (wordIndex < this.words.length) {
                int n = wordIndex;
                this.words[n] = this.words[n] & (1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
                this.trim(this.words.length);
            }
            return this;
        }

        public boolean wouldEqual(ImmutableBitSet bitSet) {
            if (this.words == null) {
                throw new IllegalArgumentException("can only use builder once");
            }
            return Arrays.equals(this.words, bitSet.words);
        }

        public int cardinality() {
            if (this.words == null) {
                throw new IllegalArgumentException("can only use builder once");
            }
            return ImmutableBitSet.countBits(this.words);
        }

        public Builder addAll(ImmutableBitSet bitSet) {
            for (Integer bit : bitSet) {
                this.set(bit);
            }
            return this;
        }

        public Builder addAll(Iterable<Integer> integers) {
            for (Integer integer : integers) {
                this.set(integer);
            }
            return this;
        }

        public Builder addAll(ImmutableIntList integers) {
            for (int i = 0; i < integers.size(); ++i) {
                this.set(integers.get(i));
            }
            return this;
        }

        public Builder removeAll(ImmutableBitSet bitSet) {
            for (Integer bit : bitSet) {
                this.clear(bit);
            }
            return this;
        }

        public Builder set(int fromIndex, int toIndex) {
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException();
            }
            if (toIndex < 0) {
                throw new IllegalArgumentException();
            }
            if (fromIndex < toIndex) {
                int startWordIndex = ImmutableBitSet.wordIndex(fromIndex);
                int endWordIndex = ImmutableBitSet.wordIndex(toIndex - 1);
                if (endWordIndex >= this.words.length) {
                    this.words = Arrays.copyOf(this.words, endWordIndex + 1);
                }
                long firstWordMask = -1L << fromIndex;
                long lastWordMask = -1L >>> -toIndex;
                if (startWordIndex == endWordIndex) {
                    int n = startWordIndex;
                    this.words[n] = this.words[n] | firstWordMask & lastWordMask;
                } else {
                    int n = startWordIndex;
                    this.words[n] = this.words[n] | firstWordMask;
                    for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                        this.words[i] = -1L;
                    }
                    int n2 = endWordIndex;
                    this.words[n2] = this.words[n2] | lastWordMask;
                }
            }
            return this;
        }

        public boolean isEmpty() {
            return this.words.length == 0;
        }

        public void intersect(ImmutableBitSet that) {
            int x = Math.min(this.words.length, that.words.length);
            for (int i = 0; i < x; ++i) {
                int n = i;
                this.words[n] = this.words[n] & that.words[i];
            }
            this.trim(x);
        }
    }

    private static class Closure {
        private SortedMap<Integer, ImmutableBitSet> equivalence;
        private final SortedMap<Integer, ImmutableBitSet> closure = new TreeMap<Integer, ImmutableBitSet>();

        Closure(SortedMap<Integer, ImmutableBitSet> equivalence) {
            this.equivalence = equivalence;
            ImmutableIntList keys = ImmutableIntList.copyOf(equivalence.keySet());
            for (int pos : keys) {
                this.computeClosure(pos);
            }
        }

        private ImmutableBitSet computeClosure(int pos) {
            ImmutableBitSet b;
            ImmutableBitSet o = (ImmutableBitSet)this.closure.get(pos);
            if (o != null) {
                return o;
            }
            o = b = (ImmutableBitSet)this.equivalence.get(pos);
            int i = b.nextSetBit(pos + 1);
            while (i >= 0) {
                o = o.union(this.computeClosure(i));
                i = b.nextSetBit(i + 1);
            }
            this.closure.put(pos, o);
            i = o.nextSetBit(pos + 1);
            while (i >= 0) {
                this.closure.put(i, o);
                i = b.nextSetBit(i + 1);
            }
            return o;
        }
    }
}

