/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.files;

import java.util.Objects;

public class HudiFileGroupId
implements Comparable<HudiFileGroupId> {
    private final String partitionPath;
    private final String fileId;

    public HudiFileGroupId(String partitionPath, String fileId) {
        this.partitionPath = Objects.requireNonNull(partitionPath, "partitionPath is null");
        this.fileId = Objects.requireNonNull(fileId, "partitionPath is null");
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public String getFileId() {
        return this.fileId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HudiFileGroupId that = (HudiFileGroupId)o;
        return Objects.equals(this.partitionPath, that.partitionPath) && Objects.equals(this.fileId, that.fileId);
    }

    public int hashCode() {
        return Objects.hash(this.partitionPath, this.fileId);
    }

    public String toString() {
        return "HoodieFileGroupId{partitionPath='" + this.partitionPath + "', fileId='" + this.fileId + "'}";
    }

    @Override
    public int compareTo(HudiFileGroupId o) {
        int ret = this.partitionPath.compareTo(o.partitionPath);
        if (ret == 0) {
            ret = this.fileId.compareTo(o.fileId);
        }
        return ret;
    }
}

