/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.timeline;

import com.google.common.base.Preconditions;
import java.util.Objects;

public class TimelineLayoutVersion
implements Comparable<TimelineLayoutVersion> {
    public static final Integer VERSION_0 = 0;
    public static final Integer VERSION_1;
    private static final Integer CURRENT_VERSION;
    public static final TimelineLayoutVersion CURRENT_LAYOUT_VERSION;
    private final Integer version;

    public TimelineLayoutVersion(Integer version) {
        Preconditions.checkArgument((version <= CURRENT_VERSION ? 1 : 0) != 0);
        Preconditions.checkArgument((version >= VERSION_0 ? 1 : 0) != 0);
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimelineLayoutVersion that = (TimelineLayoutVersion)o;
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    @Override
    public int compareTo(TimelineLayoutVersion o) {
        return Integer.compare(this.version, o.version);
    }

    public String toString() {
        return String.valueOf(this.version);
    }

    static {
        CURRENT_VERSION = VERSION_1 = Integer.valueOf(1);
        CURRENT_LAYOUT_VERSION = new TimelineLayoutVersion(CURRENT_VERSION);
    }
}

