/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import io.airlift.slice.SizeOf;
import io.trino.filesystem.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AcidInfo {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(AcidInfo.class);
    private final String partitionLocation;
    private final List<String> deleteDeltas;
    private final List<OriginalFileInfo> originalFiles;
    private final int bucketId;
    private final boolean orcAcidVersionValidated;

    @JsonCreator
    public AcidInfo(@JsonProperty(value="partitionLocation") String partitionLocation, @JsonProperty(value="deleteDeltaDirectories") List<String> deleteDeltaDirectories, @JsonProperty(value="originalFiles") List<OriginalFileInfo> originalFiles, @JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="orcAcidVersionValidated") boolean orcAcidVersionValidated) {
        this.partitionLocation = Objects.requireNonNull(partitionLocation, "partitionLocation is null");
        this.deleteDeltas = ImmutableList.copyOf((Collection)Objects.requireNonNull(deleteDeltaDirectories, "deleteDeltaDirectories is null"));
        this.originalFiles = ImmutableList.copyOf((Collection)Objects.requireNonNull(originalFiles, "originalFiles is null"));
        this.bucketId = bucketId;
        this.orcAcidVersionValidated = orcAcidVersionValidated;
    }

    @JsonProperty
    public List<OriginalFileInfo> getOriginalFiles() {
        return this.originalFiles;
    }

    @JsonProperty
    public int getBucketId() {
        return this.bucketId;
    }

    @JsonProperty
    public String getPartitionLocation() {
        return this.partitionLocation;
    }

    @JsonProperty
    public List<String> getDeleteDeltaDirectories() {
        return this.deleteDeltas;
    }

    @JsonProperty
    public boolean isOrcAcidVersionValidated() {
        return this.orcAcidVersionValidated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcidInfo that = (AcidInfo)o;
        return this.bucketId == that.bucketId && this.orcAcidVersionValidated == that.orcAcidVersionValidated && Objects.equals(this.partitionLocation, that.partitionLocation) && Objects.equals(this.deleteDeltas, that.deleteDeltas) && Objects.equals(this.originalFiles, that.originalFiles);
    }

    public int hashCode() {
        return Objects.hash(this.partitionLocation, this.deleteDeltas, this.originalFiles, this.bucketId, this.orcAcidVersionValidated);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionLocation", (Object)this.partitionLocation).add("deleteDeltas", this.deleteDeltas).add("originalFiles", this.originalFiles).add("bucketId", this.bucketId).add("orcAcidVersionValidated", this.orcAcidVersionValidated).toString();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.partitionLocation) + SizeOf.estimatedSizeOf(this.deleteDeltas, SizeOf::estimatedSizeOf) + SizeOf.estimatedSizeOf(this.originalFiles, OriginalFileInfo::getRetainedSizeInBytes);
    }

    public static Builder builder(Location partitionPath) {
        return new Builder(partitionPath);
    }

    public static class Builder {
        private final Location partitionLocation;
        private final List<String> deleteDeltaDirectories = new ArrayList<String>();
        private final ListMultimap<Integer, OriginalFileInfo> bucketIdToOriginalFileInfoMap = ArrayListMultimap.create();
        private boolean orcAcidVersionValidated;

        private Builder(Location partitionPath) {
            this.partitionLocation = Objects.requireNonNull(partitionPath, "partitionPath is null");
        }

        public Builder addDeleteDelta(Location deleteDeltaPath) {
            Objects.requireNonNull(deleteDeltaPath, "deleteDeltaPath is null");
            Location partitionPathFromDeleteDelta = deleteDeltaPath.parentDirectory();
            Preconditions.checkArgument((boolean)this.partitionLocation.equals((Object)partitionPathFromDeleteDelta), (String)"Partition location in DeleteDelta '%s' does not match stored location '%s'", (Object)partitionPathFromDeleteDelta, (Object)this.partitionLocation);
            this.deleteDeltaDirectories.add(deleteDeltaPath.fileName());
            return this;
        }

        public Builder addOriginalFile(Location originalFilePath, long originalFileSize, int bucketId) {
            Objects.requireNonNull(originalFilePath, "originalFilePath is null");
            Location partitionPathFromOriginalPath = originalFilePath.parentDirectory();
            Preconditions.checkArgument((boolean)this.partitionLocation.equals((Object)partitionPathFromOriginalPath), (String)"Partition location in OriginalFile '%s' does not match stored location '%s'", (Object)partitionPathFromOriginalPath, (Object)this.partitionLocation);
            this.bucketIdToOriginalFileInfoMap.put((Object)bucketId, (Object)new OriginalFileInfo(originalFilePath.fileName(), originalFileSize));
            return this;
        }

        public Builder setOrcAcidVersionValidated(boolean orcAcidVersionValidated) {
            this.orcAcidVersionValidated = orcAcidVersionValidated;
            return this;
        }

        public AcidInfo buildWithRequiredOriginalFiles(int bucketId) {
            Preconditions.checkState((bucketId > -1 && this.bucketIdToOriginalFileInfoMap.containsKey((Object)bucketId) ? 1 : 0) != 0, (String)"Bucket Id to OriginalFileInfo map should have entry for requested bucket id: %s", (int)bucketId);
            return new AcidInfo(this.partitionLocation.toString(), this.deleteDeltaDirectories, this.bucketIdToOriginalFileInfoMap.get((Object)bucketId), bucketId, this.orcAcidVersionValidated);
        }

        public Optional<AcidInfo> build() {
            if (this.deleteDeltaDirectories.isEmpty() && this.orcAcidVersionValidated) {
                return Optional.empty();
            }
            return Optional.of(new AcidInfo(this.partitionLocation.toString(), this.deleteDeltaDirectories, (List<OriginalFileInfo>)ImmutableList.of(), -1, this.orcAcidVersionValidated));
        }
    }

    public static class OriginalFileInfo {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(OriginalFileInfo.class);
        private final String name;
        private final long fileSize;

        @JsonCreator
        public OriginalFileInfo(@JsonProperty(value="name") String name, @JsonProperty(value="fileSize") long fileSize) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.fileSize = fileSize;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public long getFileSize() {
            return this.fileSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OriginalFileInfo that = (OriginalFileInfo)o;
            return this.fileSize == that.fileSize && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.fileSize);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("fileSize", this.fileSize).toString();
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.name);
        }
    }
}

