/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;

public class HiveSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(HiveSplit.class);
    private final String path;
    private final long start;
    private final long length;
    private final long estimatedFileSize;
    private final long fileModifiedTime;
    private final Properties schema;
    private final List<HivePartitionKey> partitionKeys;
    private final List<HostAddress> addresses;
    private final String partitionName;
    private final OptionalInt readBucketNumber;
    private final OptionalInt tableBucketNumber;
    private final boolean forceLocalScheduling;
    private final TableToPartitionMapping tableToPartitionMapping;
    private final Optional<BucketConversion> bucketConversion;
    private final Optional<BucketValidation> bucketValidation;
    private final Optional<AcidInfo> acidInfo;
    private final SplitWeight splitWeight;

    @JsonCreator
    public HiveSplit(@JsonProperty(value="partitionName") String partitionName, @JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="estimatedFileSize") long estimatedFileSize, @JsonProperty(value="fileModifiedTime") long fileModifiedTime, @JsonProperty(value="schema") Properties schema, @JsonProperty(value="partitionKeys") List<HivePartitionKey> partitionKeys, @JsonProperty(value="readBucketNumber") OptionalInt readBucketNumber, @JsonProperty(value="tableBucketNumber") OptionalInt tableBucketNumber, @JsonProperty(value="forceLocalScheduling") boolean forceLocalScheduling, @JsonProperty(value="tableToPartitionMapping") TableToPartitionMapping tableToPartitionMapping, @JsonProperty(value="bucketConversion") Optional<BucketConversion> bucketConversion, @JsonProperty(value="bucketValidation") Optional<BucketValidation> bucketValidation, @JsonProperty(value="acidInfo") Optional<AcidInfo> acidInfo, @JsonProperty(value="splitWeight") SplitWeight splitWeight) {
        this(partitionName, path, start, length, estimatedFileSize, fileModifiedTime, schema, partitionKeys, (List<HostAddress>)ImmutableList.of(), readBucketNumber, tableBucketNumber, forceLocalScheduling, tableToPartitionMapping, bucketConversion, bucketValidation, acidInfo, splitWeight);
    }

    public HiveSplit(String partitionName, String path, long start, long length, long estimatedFileSize, long fileModifiedTime, Properties schema, List<HivePartitionKey> partitionKeys, List<HostAddress> addresses, OptionalInt readBucketNumber, OptionalInt tableBucketNumber, boolean forceLocalScheduling, TableToPartitionMapping tableToPartitionMapping, Optional<BucketConversion> bucketConversion, Optional<BucketValidation> bucketValidation, Optional<AcidInfo> acidInfo, SplitWeight splitWeight) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start must be positive");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length must be positive");
        Preconditions.checkArgument((estimatedFileSize >= 0L ? 1 : 0) != 0, (Object)"estimatedFileSize must be positive");
        Objects.requireNonNull(partitionName, "partitionName is null");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(addresses, "addresses is null");
        Objects.requireNonNull(readBucketNumber, "readBucketNumber is null");
        Objects.requireNonNull(tableBucketNumber, "tableBucketNumber is null");
        Objects.requireNonNull(tableToPartitionMapping, "tableToPartitionMapping is null");
        Objects.requireNonNull(bucketConversion, "bucketConversion is null");
        Objects.requireNonNull(bucketValidation, "bucketValidation is null");
        Objects.requireNonNull(acidInfo, "acidInfo is null");
        this.partitionName = partitionName;
        this.path = path;
        this.start = start;
        this.length = length;
        this.estimatedFileSize = estimatedFileSize;
        this.fileModifiedTime = fileModifiedTime;
        this.schema = schema;
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.addresses = ImmutableList.copyOf(addresses);
        this.readBucketNumber = readBucketNumber;
        this.tableBucketNumber = tableBucketNumber;
        this.forceLocalScheduling = forceLocalScheduling;
        this.tableToPartitionMapping = tableToPartitionMapping;
        this.bucketConversion = bucketConversion;
        this.bucketValidation = bucketValidation;
        this.acidInfo = acidInfo;
        this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
    }

    @JsonProperty
    public String getPartitionName() {
        return this.partitionName;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public long getEstimatedFileSize() {
        return this.estimatedFileSize;
    }

    @JsonProperty
    public long getFileModifiedTime() {
        return this.fileModifiedTime;
    }

    @JsonProperty
    public Properties getSchema() {
        return this.schema;
    }

    @JsonProperty
    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    @JsonIgnore
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public OptionalInt getReadBucketNumber() {
        return this.readBucketNumber;
    }

    @JsonProperty
    public OptionalInt getTableBucketNumber() {
        return this.tableBucketNumber;
    }

    @JsonProperty
    public boolean isForceLocalScheduling() {
        return this.forceLocalScheduling;
    }

    @JsonProperty
    public TableToPartitionMapping getTableToPartitionMapping() {
        return this.tableToPartitionMapping;
    }

    @JsonProperty
    public Optional<BucketConversion> getBucketConversion() {
        return this.bucketConversion;
    }

    @JsonProperty
    public Optional<BucketValidation> getBucketValidation() {
        return this.bucketValidation;
    }

    public boolean isRemotelyAccessible() {
        return !this.forceLocalScheduling;
    }

    @JsonProperty
    public Optional<AcidInfo> getAcidInfo() {
        return this.acidInfo;
    }

    @JsonProperty
    public SplitWeight getSplitWeight() {
        return this.splitWeight;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + SizeOf.estimatedSizeOf((Map)this.schema, key -> SizeOf.estimatedSizeOf((String)((String)key)), value -> SizeOf.estimatedSizeOf((String)((String)value))) + SizeOf.estimatedSizeOf(this.partitionKeys, HivePartitionKey::getEstimatedSizeInBytes) + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf((String)this.partitionName) + SizeOf.sizeOf((OptionalInt)this.readBucketNumber) + SizeOf.sizeOf((OptionalInt)this.tableBucketNumber) + (long)this.tableToPartitionMapping.getEstimatedSizeInBytes() + SizeOf.sizeOf(this.bucketConversion, BucketConversion::getRetainedSizeInBytes) + SizeOf.sizeOf(this.bucketValidation, BucketValidation::getRetainedSizeInBytes) + SizeOf.sizeOf(this.acidInfo, AcidInfo::getRetainedSizeInBytes) + this.splitWeight.getRetainedSizeInBytes();
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.path).put((Object)"start", (Object)this.start).put((Object)"length", (Object)this.length).put((Object)"estimatedFileSize", (Object)this.estimatedFileSize).put((Object)"hosts", this.addresses).put((Object)"forceLocalScheduling", (Object)this.forceLocalScheduling).put((Object)"partitionName", (Object)this.partitionName).put((Object)"deserializerClassName", (Object)HiveUtil.getDeserializerClassName(this.schema)).buildOrThrow();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).addValue(this.start).addValue(this.length).addValue(this.estimatedFileSize).toString();
    }

    public record BucketValidation(HiveBucketing.BucketingVersion bucketingVersion, int bucketCount, List<HiveColumnHandle> bucketColumns) {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(BucketValidation.class);

        public BucketValidation {
            Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
            bucketColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketColumns, "bucketColumns is null"));
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.bucketColumns, HiveColumnHandle::getRetainedSizeInBytes);
        }
    }

    public record BucketConversion(HiveBucketing.BucketingVersion bucketingVersion, int tableBucketCount, int partitionBucketCount, List<HiveColumnHandle> bucketColumnHandles) {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(BucketConversion.class);

        public BucketConversion {
            Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
            Objects.requireNonNull(bucketColumnHandles, "bucketColumnHandles is null");
            bucketColumnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketColumnHandles, "bucketColumnHandles is null"));
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.bucketColumnHandles, HiveColumnHandle::getRetainedSizeInBytes);
        }
    }
}

