/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.aws.athena.projection;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.aws.athena.PartitionProjectionProperties;
import io.trino.plugin.hive.aws.athena.projection.IntegerProjection;
import io.trino.plugin.hive.aws.athena.projection.Projection;
import io.trino.plugin.hive.aws.athena.projection.ProjectionFactory;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;

public class IntegerProjectionFactory
implements ProjectionFactory {
    @Override
    public boolean isSupportedColumnType(Type columnType) {
        return columnType instanceof VarcharType || columnType instanceof IntegerType || columnType instanceof BigintType;
    }

    @Override
    public Projection create(String columnName, Type columnType, Map<String, Object> columnProperties) {
        List range = (List)PartitionProjectionProperties.getProjectionPropertyRequiredValue(columnName, columnProperties, "partition_projection_range", value -> (ImmutableList)((List)value).stream().map(element -> Integer.valueOf((String)element)).collect(ImmutableList.toImmutableList()));
        if (range.size() != 2) {
            Projection.invalidProjectionException(columnName, String.format("Property: '%s' needs to be list of 2 integers", "partition_projection_range"));
        }
        return new IntegerProjection(columnName, (Integer)range.get(0), (Integer)range.get(1), PartitionProjectionProperties.getProjectionPropertyValue(columnProperties, "partition_projection_interval", Integer.class::cast).orElse(1), PartitionProjectionProperties.getProjectionPropertyValue(columnProperties, "partition_projection_digits", Integer.class::cast));
    }
}

