/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.converter;

import com.amazonaws.services.glue.model.Order;
import com.amazonaws.services.glue.model.SerDeInfo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.Storage;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.util.Memoizers;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.PrincipalType;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public final class GlueToTrinoConverter {
    private static final String PUBLIC_OWNER = "PUBLIC";

    private GlueToTrinoConverter() {
    }

    @SuppressModernizer
    public static Map<String, String> getColumnParameters(com.amazonaws.services.glue.model.Column glueColumn) {
        return (Map)MoreObjects.firstNonNull((Object)glueColumn.getParameters(), (Object)ImmutableMap.of());
    }

    public static String getTableType(com.amazonaws.services.glue.model.Table glueTable) {
        return (String)MoreObjects.firstNonNull((Object)GlueToTrinoConverter.getTableTypeNullable(glueTable), (Object)TableType.EXTERNAL_TABLE.name());
    }

    @Nullable
    @SuppressModernizer
    public static String getTableTypeNullable(com.amazonaws.services.glue.model.Table glueTable) {
        return glueTable.getTableType();
    }

    @SuppressModernizer
    public static Map<String, String> getTableParameters(com.amazonaws.services.glue.model.Table glueTable) {
        return (Map)MoreObjects.firstNonNull((Object)glueTable.getParameters(), (Object)ImmutableMap.of());
    }

    @SuppressModernizer
    public static Map<String, String> getPartitionParameters(com.amazonaws.services.glue.model.Partition gluePartition) {
        return (Map)MoreObjects.firstNonNull((Object)gluePartition.getParameters(), (Object)ImmutableMap.of());
    }

    @SuppressModernizer
    public static Map<String, String> getSerDeInfoParameters(SerDeInfo glueSerDeInfo) {
        return (Map)MoreObjects.firstNonNull((Object)glueSerDeInfo.getParameters(), (Object)ImmutableMap.of());
    }

    public static Database convertDatabase(com.amazonaws.services.glue.model.Database glueDb) {
        return Database.builder().setDatabaseName(glueDb.getName()).setLocation(Optional.ofNullable(Strings.emptyToNull((String)glueDb.getLocationUri()))).setComment(Optional.ofNullable(glueDb.getDescription())).setParameters((Map)MoreObjects.firstNonNull((Object)glueDb.getParameters(), (Object)ImmutableMap.of())).setOwnerName(Optional.of(PUBLIC_OWNER)).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
    }

    public static Table convertTable(com.amazonaws.services.glue.model.Table glueTable, String dbName) {
        SchemaTableName table = new SchemaTableName(dbName, glueTable.getName());
        String tableType = GlueToTrinoConverter.getTableType(glueTable);
        ImmutableMap tableParameters = ImmutableMap.copyOf(GlueToTrinoConverter.getTableParameters(glueTable));
        Table.Builder tableBuilder = Table.builder().setDatabaseName(table.getSchemaName()).setTableName(table.getTableName()).setOwner(Optional.ofNullable(glueTable.getOwner())).setTableType(tableType).setParameters((Map<String, String>)tableParameters).setViewOriginalText(Optional.ofNullable(glueTable.getViewOriginalText())).setViewExpandedText(Optional.ofNullable(glueTable.getViewExpandedText()));
        StorageDescriptor sd = glueTable.getStorageDescriptor();
        if (HiveUtil.isIcebergTable((Map<String, String>)tableParameters) || sd == null && HiveUtil.isDeltaLakeTable((Map<String, String>)tableParameters) || sd == null && ViewReaderUtil.isTrinoMaterializedView(tableType, (Map<String, String>)tableParameters)) {
            tableBuilder.setDataColumns((List<Column>)ImmutableList.of((Object)new Column("dummy", HiveType.HIVE_INT, Optional.empty(), (Map<String, String>)ImmutableMap.of())));
            tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.fromHiveStorageFormat(HiveStorageFormat.PARQUET));
        } else {
            if (sd == null) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Table StorageDescriptor is null for table '%s' %s".formatted(table, glueTable));
            }
            boolean isCsv = sd.getSerdeInfo() != null && HiveStorageFormat.CSV.getSerde().equals(sd.getSerdeInfo().getSerializationLibrary());
            tableBuilder.setDataColumns(GlueToTrinoConverter.convertColumns(table, sd.getColumns(), isCsv));
            if (glueTable.getPartitionKeys() != null) {
                tableBuilder.setPartitionColumns(GlueToTrinoConverter.convertColumns(table, glueTable.getPartitionKeys(), isCsv));
            } else {
                tableBuilder.setPartitionColumns((List<Column>)ImmutableList.of());
            }
            new StorageConverter().setStorageBuilder(sd, tableBuilder.getStorageBuilder(), (Map<String, String>)tableParameters);
        }
        return tableBuilder.build();
    }

    private static Column convertColumn(SchemaTableName table, com.amazonaws.services.glue.model.Column glueColumn, boolean isCsv) {
        if (isCsv) {
            return new Column(glueColumn.getName(), HiveType.HIVE_STRING, Optional.ofNullable(glueColumn.getComment()), GlueToTrinoConverter.getColumnParameters(glueColumn));
        }
        return new Column(glueColumn.getName(), GlueToTrinoConverter.convertType(table, glueColumn), Optional.ofNullable(glueColumn.getComment()), GlueToTrinoConverter.getColumnParameters(glueColumn));
    }

    private static HiveType convertType(SchemaTableName table, com.amazonaws.services.glue.model.Column column) {
        try {
            return HiveType.valueOf(column.getType().toLowerCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Glue table '%s' column '%s' has invalid data type: %s".formatted(table, column.getName(), column.getType()));
        }
    }

    private static List<Column> convertColumns(SchemaTableName table, List<com.amazonaws.services.glue.model.Column> glueColumns, boolean isCsv) {
        return GlueToTrinoConverter.mappedCopy(glueColumns, glueColumn -> GlueToTrinoConverter.convertColumn(table, glueColumn, isCsv));
    }

    private static Function<Map<String, String>, Map<String, String>> parametersConverter() {
        return Memoizers.memoizeLast(ImmutableMap::copyOf);
    }

    private static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static <T, R> List<R> mappedCopy(List<T> list, Function<T, R> mapper) {
        Objects.requireNonNull(list, "list is null");
        Objects.requireNonNull(mapper, "mapper is null");
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)list.size());
        for (T item : list) {
            builder.add(mapper.apply(item));
        }
        return builder.build();
    }

    private static final class StorageConverter {
        private final Function<List<String>, List<String>> bucketColumns = Memoizers.memoizeLast(ImmutableList::copyOf);
        private final Function<List<Order>, List<SortingColumn>> sortColumns = Memoizers.memoizeLast(StorageConverter::createSortingColumns);
        private final UnaryOperator<Optional<HiveBucketProperty>> bucketProperty = Memoizers.memoizeLast();
        private final Function<Map<String, String>, Map<String, String>> serdeParametersConverter = GlueToTrinoConverter.parametersConverter();
        private final StorageFormatConverter storageFormatConverter = new StorageFormatConverter();

        private StorageConverter() {
        }

        public void setStorageBuilder(StorageDescriptor sd, Storage.Builder storageBuilder, Map<String, String> tableParameters) {
            Objects.requireNonNull(sd.getSerdeInfo(), "StorageDescriptor SerDeInfo is null");
            SerDeInfo serdeInfo = sd.getSerdeInfo();
            storageBuilder.setStorageFormat(this.storageFormatConverter.createStorageFormat(serdeInfo, sd)).setLocation(Strings.nullToEmpty((String)sd.getLocation())).setBucketProperty(this.convertToBucketProperty(tableParameters, sd)).setSkewed(sd.getSkewedInfo() != null && !GlueToTrinoConverter.isNullOrEmpty(sd.getSkewedInfo().getSkewedColumnNames())).setSerdeParameters(this.serdeParametersConverter.apply(GlueToTrinoConverter.getSerDeInfoParameters(serdeInfo))).build();
        }

        private Optional<HiveBucketProperty> convertToBucketProperty(Map<String, String> tableParameters, StorageDescriptor sd) {
            if (sd.getNumberOfBuckets() > 0) {
                if (GlueToTrinoConverter.isNullOrEmpty(sd.getBucketColumns())) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table/partition metadata has 'numBuckets' set, but 'bucketCols' is not set");
                }
                List<String> bucketColumns = this.bucketColumns.apply(sd.getBucketColumns());
                List<SortingColumn> sortedBy = this.sortColumns.apply(sd.getSortColumns());
                HiveBucketing.BucketingVersion bucketingVersion = HiveBucketing.getBucketingVersion(tableParameters);
                return (Optional)this.bucketProperty.apply(Optional.of(new HiveBucketProperty(bucketColumns, bucketingVersion, sd.getNumberOfBuckets(), sortedBy)));
            }
            return Optional.empty();
        }

        private static List<SortingColumn> createSortingColumns(List<Order> sortColumns) {
            if (GlueToTrinoConverter.isNullOrEmpty(sortColumns)) {
                return ImmutableList.of();
            }
            return GlueToTrinoConverter.mappedCopy(sortColumns, column -> new SortingColumn(column.getColumn(), SortingColumn.Order.fromMetastoreApiOrder(column.getSortOrder(), "unknown")));
        }
    }

    private static final class StorageFormatConverter {
        private static final StorageFormat ALL_NULLS = StorageFormat.createNullable(null, null, null);
        private final UnaryOperator<String> serializationLib = Memoizers.memoizeLast();
        private final UnaryOperator<String> inputFormat = Memoizers.memoizeLast();
        private final UnaryOperator<String> outputFormat = Memoizers.memoizeLast();
        private final UnaryOperator<StorageFormat> storageFormat = Memoizers.memoizeLast();

        private StorageFormatConverter() {
        }

        public StorageFormat createStorageFormat(SerDeInfo serdeInfo, StorageDescriptor storageDescriptor) {
            String serializationLib = (String)this.serializationLib.apply(serdeInfo.getSerializationLibrary());
            String inputFormat = (String)this.inputFormat.apply(storageDescriptor.getInputFormat());
            String outputFormat = (String)this.outputFormat.apply(storageDescriptor.getOutputFormat());
            if (serializationLib == null && inputFormat == null && outputFormat == null) {
                return ALL_NULLS;
            }
            return (StorageFormat)this.storageFormat.apply(StorageFormat.createNullable(serializationLib, inputFormat, outputFormat));
        }
    }

    public static final class GluePartitionConverter
    implements Function<com.amazonaws.services.glue.model.Partition, Partition> {
        private final BiFunction<List<com.amazonaws.services.glue.model.Column>, Boolean, List<Column>> columnsConverter;
        private final Function<Map<String, String>, Map<String, String>> parametersConverter = GlueToTrinoConverter.parametersConverter();
        private final StorageConverter storageConverter = new StorageConverter();
        private final String databaseName;
        private final String tableName;
        private final Map<String, String> tableParameters;

        public GluePartitionConverter(Table table) {
            Objects.requireNonNull(table, "table is null");
            this.databaseName = Objects.requireNonNull(table.getDatabaseName(), "databaseName is null");
            this.tableName = Objects.requireNonNull(table.getTableName(), "tableName is null");
            this.tableParameters = table.getParameters();
            this.columnsConverter = Memoizers.memoizeLast((glueColumns, isCsv) -> GlueToTrinoConverter.convertColumns(table.getSchemaTableName(), glueColumns, isCsv));
        }

        @Override
        public Partition apply(com.amazonaws.services.glue.model.Partition gluePartition) {
            Objects.requireNonNull(gluePartition.getStorageDescriptor(), "Partition StorageDescriptor is null");
            StorageDescriptor sd = gluePartition.getStorageDescriptor();
            if (!this.databaseName.equals(gluePartition.getDatabaseName())) {
                throw new IllegalArgumentException(String.format("Unexpected databaseName, expected: %s, but found: %s", this.databaseName, gluePartition.getDatabaseName()));
            }
            if (!this.tableName.equals(gluePartition.getTableName())) {
                throw new IllegalArgumentException(String.format("Unexpected tableName, expected: %s, but found: %s", this.tableName, gluePartition.getTableName()));
            }
            boolean isCsv = sd.getSerdeInfo() != null && HiveStorageFormat.CSV.getSerde().equals(sd.getSerdeInfo().getSerializationLibrary());
            Partition.Builder partitionBuilder = Partition.builder().setDatabaseName(this.databaseName).setTableName(this.tableName).setValues(gluePartition.getValues()).setColumns(this.columnsConverter.apply(sd.getColumns(), isCsv)).setParameters(this.parametersConverter.apply(GlueToTrinoConverter.getPartitionParameters(gluePartition)));
            this.storageConverter.setStorageBuilder(sd, partitionBuilder.getStorageBuilder(), this.tableParameters);
            return partitionBuilder.build();
        }
    }
}

