/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Reflection;
import io.airlift.log.Logger;
import io.trino.hive.thrift.metastore.AbortTxnRequest;
import io.trino.hive.thrift.metastore.AddDynamicPartitions;
import io.trino.hive.thrift.metastore.AllocateTableWriteIdsRequest;
import io.trino.hive.thrift.metastore.AllocateTableWriteIdsResponse;
import io.trino.hive.thrift.metastore.AlterPartitionsRequest;
import io.trino.hive.thrift.metastore.AlterTableRequest;
import io.trino.hive.thrift.metastore.CheckLockRequest;
import io.trino.hive.thrift.metastore.ClientCapabilities;
import io.trino.hive.thrift.metastore.ClientCapability;
import io.trino.hive.thrift.metastore.ColumnStatistics;
import io.trino.hive.thrift.metastore.ColumnStatisticsDesc;
import io.trino.hive.thrift.metastore.ColumnStatisticsObj;
import io.trino.hive.thrift.metastore.CommitTxnRequest;
import io.trino.hive.thrift.metastore.Database;
import io.trino.hive.thrift.metastore.EnvironmentContext;
import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.hive.thrift.metastore.GetPrincipalsInRoleRequest;
import io.trino.hive.thrift.metastore.GetPrincipalsInRoleResponse;
import io.trino.hive.thrift.metastore.GetRoleGrantsForPrincipalRequest;
import io.trino.hive.thrift.metastore.GetRoleGrantsForPrincipalResponse;
import io.trino.hive.thrift.metastore.GetTableRequest;
import io.trino.hive.thrift.metastore.GetValidWriteIdsRequest;
import io.trino.hive.thrift.metastore.GrantRevokePrivilegeRequest;
import io.trino.hive.thrift.metastore.GrantRevokeRoleRequest;
import io.trino.hive.thrift.metastore.GrantRevokeRoleResponse;
import io.trino.hive.thrift.metastore.GrantRevokeType;
import io.trino.hive.thrift.metastore.HeartbeatTxnRangeRequest;
import io.trino.hive.thrift.metastore.HiveObjectPrivilege;
import io.trino.hive.thrift.metastore.HiveObjectRef;
import io.trino.hive.thrift.metastore.LockRequest;
import io.trino.hive.thrift.metastore.LockResponse;
import io.trino.hive.thrift.metastore.MetaException;
import io.trino.hive.thrift.metastore.NoSuchObjectException;
import io.trino.hive.thrift.metastore.OpenTxnRequest;
import io.trino.hive.thrift.metastore.Partition;
import io.trino.hive.thrift.metastore.PartitionsStatsRequest;
import io.trino.hive.thrift.metastore.PrincipalType;
import io.trino.hive.thrift.metastore.PrivilegeBag;
import io.trino.hive.thrift.metastore.Role;
import io.trino.hive.thrift.metastore.RolePrincipalGrant;
import io.trino.hive.thrift.metastore.Table;
import io.trino.hive.thrift.metastore.TableMeta;
import io.trino.hive.thrift.metastore.TableStatsRequest;
import io.trino.hive.thrift.metastore.ThriftHiveMetastore;
import io.trino.hive.thrift.metastore.TxnToWriteId;
import io.trino.hive.thrift.metastore.UnlockRequest;
import io.trino.plugin.base.util.LoggingInvocationHandler;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.metastore.thrift.MetastoreSupportsDateStatistics;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.TxnUtils;
import io.trino.spi.connector.SchemaTableName;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class ThriftHiveMetastoreClient
implements ThriftMetastoreClient {
    private static final Logger log = Logger.get(ThriftHiveMetastoreClient.class);
    private static final Pattern TABLE_PARAMETER_SAFE_KEY_PATTERN = Pattern.compile("^[a-zA-Z_]+$");
    private static final Pattern TABLE_PARAMETER_SAFE_VALUE_PATTERN = Pattern.compile("^[a-zA-Z0-9\\s]*$");
    private final TransportSupplier transportSupplier;
    private TTransport transport;
    protected ThriftHiveMetastore.Iface client;
    private final String hostname;
    private final MetastoreSupportsDateStatistics metastoreSupportsDateStatistics;
    private final AtomicInteger chosenGetTableAlternative;
    private final AtomicInteger chosenTableParamAlternative;
    private final AtomicInteger chosenGetAllTablesAlternative;
    private final AtomicInteger chosenGetAllViewsPerDatabaseAlternative;
    private final AtomicInteger chosenGetAllViewsAlternative;
    private final AtomicInteger chosenAlterTransactionalTableAlternative;
    private final AtomicInteger chosenAlterPartitionsAlternative;

    public ThriftHiveMetastoreClient(TransportSupplier transportSupplier, String hostname, MetastoreSupportsDateStatistics metastoreSupportsDateStatistics, AtomicInteger chosenGetTableAlternative, AtomicInteger chosenTableParamAlternative, AtomicInteger chosenGetAllTablesAlternative, AtomicInteger chosenGetAllViewsPerDatabaseAlternative, AtomicInteger chosenGetAllViewsAlternative, AtomicInteger chosenAlterTransactionalTableAlternative, AtomicInteger chosenAlterPartitionsAlternative) throws TTransportException {
        this.transportSupplier = Objects.requireNonNull(transportSupplier, "transportSupplier is null");
        this.hostname = Objects.requireNonNull(hostname, "hostname is null");
        this.metastoreSupportsDateStatistics = Objects.requireNonNull(metastoreSupportsDateStatistics, "metastoreSupportsDateStatistics is null");
        this.chosenGetTableAlternative = Objects.requireNonNull(chosenGetTableAlternative, "chosenGetTableAlternative is null");
        this.chosenTableParamAlternative = Objects.requireNonNull(chosenTableParamAlternative, "chosenTableParamAlternative is null");
        this.chosenGetAllViewsPerDatabaseAlternative = Objects.requireNonNull(chosenGetAllViewsPerDatabaseAlternative, "chosenGetAllViewsPerDatabaseAlternative is null");
        this.chosenAlterTransactionalTableAlternative = Objects.requireNonNull(chosenAlterTransactionalTableAlternative, "chosenAlterTransactionalTableAlternative is null");
        this.chosenAlterPartitionsAlternative = Objects.requireNonNull(chosenAlterPartitionsAlternative, "chosenAlterPartitionsAlternative is null");
        this.chosenGetAllTablesAlternative = Objects.requireNonNull(chosenGetAllTablesAlternative, "chosenGetAllTablesAlternative is null");
        this.chosenGetAllViewsAlternative = Objects.requireNonNull(chosenGetAllViewsAlternative, "chosenGetAllViewsAlternative is null");
        this.connect();
    }

    private void connect() throws TTransportException {
        this.transport = this.transportSupplier.createTransport();
        ThriftHiveMetastore.Client client = new ThriftHiveMetastore.Client((TProtocol)new TBinaryProtocol(this.transport));
        if (log.isDebugEnabled()) {
            client = (ThriftHiveMetastore.Iface)Reflection.newProxy(ThriftHiveMetastore.Iface.class, (InvocationHandler)new LoggingInvocationHandler((Object)client, arg_0 -> ((Logger)log).debug(arg_0)));
        }
        this.client = client;
    }

    @Override
    public void close() {
        this.disconnect();
    }

    private void disconnect() {
        this.transport.close();
    }

    @Override
    public List<String> getAllDatabases() throws TException {
        return this.client.getAllDatabases();
    }

    @Override
    public Database getDatabase(String dbName) throws TException {
        return this.client.getDatabase(dbName);
    }

    @Override
    public List<String> getAllTables(String databaseName) throws TException {
        return this.client.getAllTables(databaseName);
    }

    @Override
    public Optional<List<SchemaTableName>> getAllTables() throws TException {
        return (Optional)this.alternativeCall(exception -> !ThriftHiveMetastoreClient.isUnknownMethodExceptionalResponse(exception), this.chosenGetAllTablesAlternative, () -> ThriftHiveMetastoreClient.getSchemaTableNames(this.client.getTableMeta("*", "*", (List)ImmutableList.of())), Optional::empty);
    }

    @Override
    public List<String> getAllViews(String databaseName) throws TException {
        return (List)this.alternativeCall(exception -> !ThriftHiveMetastoreClient.isUnknownMethodExceptionalResponse(exception), this.chosenGetAllViewsPerDatabaseAlternative, () -> this.client.getTablesByType(databaseName, ".*", TableType.VIRTUAL_VIEW.name()), () -> this.getTablesWithParameter(databaseName, "presto_view", "true"));
    }

    @Override
    public Optional<List<SchemaTableName>> getAllViews() throws TException {
        return (Optional)this.alternativeCall(exception -> !ThriftHiveMetastoreClient.isUnknownMethodExceptionalResponse(exception), this.chosenGetAllViewsAlternative, () -> ThriftHiveMetastoreClient.getSchemaTableNames(this.client.getTableMeta("*", "*", (List)ImmutableList.of((Object)TableType.VIRTUAL_VIEW.name()))), Optional::empty);
    }

    private static Optional<List<SchemaTableName>> getSchemaTableNames(List<TableMeta> tablesMetadata) {
        return Optional.of((List)tablesMetadata.stream().map(metadata -> new SchemaTableName(metadata.getDbName(), metadata.getTableName())).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) throws TException {
        Preconditions.checkArgument((boolean)TABLE_PARAMETER_SAFE_KEY_PATTERN.matcher(parameterKey).matches(), (String)"Parameter key contains invalid characters: '%s'", (Object)parameterKey);
        Preconditions.checkArgument((boolean)TABLE_PARAMETER_SAFE_VALUE_PATTERN.matcher(parameterValue).matches(), (String)"Parameter value contains invalid characters: '%s'", (Object)parameterValue);
        String filterWithEquals = "hive_filter_field_params__" + parameterKey + " = \"" + parameterValue + "\"";
        String filterWithLike = "hive_filter_field_params__" + parameterKey + " LIKE \"" + parameterValue + "\"";
        return (List)this.alternativeCall(ThriftHiveMetastoreClient::defaultIsValidExceptionalResponse, this.chosenTableParamAlternative, () -> this.client.getTableNamesByFilter(databaseName, filterWithEquals, (short)-1), () -> this.client.getTableNamesByFilter(databaseName, filterWithLike, (short)-1));
    }

    @Override
    public void createDatabase(Database database) throws TException {
        this.client.createDatabase(database);
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData, boolean cascade) throws TException {
        this.client.dropDatabase(databaseName, deleteData, cascade);
    }

    @Override
    public void alterDatabase(String databaseName, Database database) throws TException {
        this.client.alterDatabase(databaseName, database);
    }

    @Override
    public void createTable(Table table) throws TException {
        this.client.createTable(table);
    }

    @Override
    public void dropTable(String databaseName, String name, boolean deleteData) throws TException {
        this.client.dropTable(databaseName, name, deleteData);
    }

    @Override
    public void alterTableWithEnvironmentContext(String databaseName, String tableName, Table newTable, EnvironmentContext context) throws TException {
        this.client.alterTableWithEnvironmentContext(databaseName, tableName, newTable, context);
    }

    @Override
    public Table getTable(String databaseName, String tableName) throws TException {
        return (Table)this.alternativeCall(ThriftHiveMetastoreClient::defaultIsValidExceptionalResponse, this.chosenGetTableAlternative, () -> {
            GetTableRequest request = new GetTableRequest(databaseName, tableName);
            request.setCapabilities(new ClientCapabilities((List)ImmutableList.of((Object)ClientCapability.INSERT_ONLY_TABLES)));
            return this.client.getTableReq(request).getTable();
        }, () -> this.client.getTable(databaseName, tableName));
    }

    @Override
    public List<FieldSchema> getFields(String databaseName, String tableName) throws TException {
        return this.client.getFields(databaseName, tableName);
    }

    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String databaseName, String tableName, List<String> columnNames) throws TException {
        TableStatsRequest tableStatsRequest = new TableStatsRequest(databaseName, tableName, columnNames);
        return this.client.getTableStatisticsReq(tableStatsRequest).getTableStats();
    }

    @Override
    public void setTableColumnStatistics(String databaseName, String tableName, List<ColumnStatisticsObj> statistics) throws TException {
        this.setColumnStatistics(String.format("table %s.%s", databaseName, tableName), statistics, stats -> {
            ColumnStatisticsDesc statisticsDescription = new ColumnStatisticsDesc(true, databaseName, tableName);
            ColumnStatistics request = new ColumnStatistics(statisticsDescription, stats);
            this.client.updateTableColumnStatistics(request);
        });
    }

    @Override
    public void deleteTableColumnStatistics(String databaseName, String tableName, String columnName) throws TException {
        this.client.deleteTableColumnStatistics(databaseName, tableName, columnName);
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String databaseName, String tableName, List<String> partitionNames, List<String> columnNames) throws TException {
        PartitionsStatsRequest partitionsStatsRequest = new PartitionsStatsRequest(databaseName, tableName, columnNames, partitionNames);
        return this.client.getPartitionsStatisticsReq(partitionsStatsRequest).getPartStats();
    }

    @Override
    public void setPartitionColumnStatistics(String databaseName, String tableName, String partitionName, List<ColumnStatisticsObj> statistics) throws TException {
        this.setColumnStatistics(String.format("partition of table %s.%s", databaseName, tableName), statistics, stats -> {
            ColumnStatisticsDesc statisticsDescription = new ColumnStatisticsDesc(false, databaseName, tableName);
            statisticsDescription.setPartName(partitionName);
            ColumnStatistics request = new ColumnStatistics(statisticsDescription, stats);
            this.client.updatePartitionColumnStatistics(request);
        });
    }

    @Override
    public void deletePartitionColumnStatistics(String databaseName, String tableName, String partitionName, String columnName) throws TException {
        this.client.deletePartitionColumnStatistics(databaseName, tableName, partitionName, columnName);
    }

    private void setColumnStatistics(String objectName, List<ColumnStatisticsObj> statistics, UnaryCall<List<ColumnStatisticsObj>> saveColumnStatistics) throws TException {
        boolean containsDateStatistics = statistics.stream().anyMatch(stats -> stats.getStatsData().isSetDateStats());
        MetastoreSupportsDateStatistics.DateStatisticsSupport dateStatisticsSupported = this.metastoreSupportsDateStatistics.isSupported();
        if (containsDateStatistics && dateStatisticsSupported == MetastoreSupportsDateStatistics.DateStatisticsSupport.NOT_SUPPORTED) {
            log.debug("Skipping date statistics for %s because metastore does not support them", new Object[]{objectName});
            statistics = (List)statistics.stream().filter(stats -> !stats.getStatsData().isSetDateStats()).collect(ImmutableList.toImmutableList());
            containsDateStatistics = false;
        }
        if (!containsDateStatistics || dateStatisticsSupported == MetastoreSupportsDateStatistics.DateStatisticsSupport.SUPPORTED) {
            saveColumnStatistics.call(statistics);
            return;
        }
        List statisticsExceptDate = (List)statistics.stream().filter(stats -> !stats.getStatsData().isSetDateStats()).collect(ImmutableList.toImmutableList());
        List dateStatistics = (List)statistics.stream().filter(stats -> stats.getStatsData().isSetDateStats()).collect(ImmutableList.toImmutableList());
        Verify.verify((!dateStatistics.isEmpty() && dateStatisticsSupported == MetastoreSupportsDateStatistics.DateStatisticsSupport.UNKNOWN ? 1 : 0) != 0);
        if (!statisticsExceptDate.isEmpty()) {
            saveColumnStatistics.call(statisticsExceptDate);
        }
        try {
            saveColumnStatistics.call(dateStatistics);
        }
        catch (TException e) {
            log.warn((Throwable)e, "Failed to save date statistics for %s. Metastore might not support date statistics", new Object[]{objectName});
            if (!statisticsExceptDate.isEmpty()) {
                this.metastoreSupportsDateStatistics.failed();
            }
            return;
        }
        this.metastoreSupportsDateStatistics.succeeded();
    }

    @Override
    public List<String> getPartitionNames(String databaseName, String tableName) throws TException {
        return this.client.getPartitionNames(databaseName, tableName, (short)-1);
    }

    @Override
    public List<String> getPartitionNamesFiltered(String databaseName, String tableName, List<String> partitionValues) throws TException {
        return this.client.getPartitionNamesPs(databaseName, tableName, partitionValues, (short)-1);
    }

    @Override
    public int addPartitions(List<Partition> newPartitions) throws TException {
        return this.client.addPartitions(newPartitions);
    }

    @Override
    public boolean dropPartition(String databaseName, String tableName, List<String> partitionValues, boolean deleteData) throws TException {
        return this.client.dropPartition(databaseName, tableName, partitionValues, deleteData);
    }

    @Override
    public void alterPartition(String databaseName, String tableName, Partition partition) throws TException {
        this.client.alterPartition(databaseName, tableName, partition);
    }

    @Override
    public Partition getPartition(String databaseName, String tableName, List<String> partitionValues) throws TException {
        return this.client.getPartition(databaseName, tableName, partitionValues);
    }

    @Override
    public List<Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws TException {
        return this.client.getPartitionsByNames(databaseName, tableName, partitionNames);
    }

    @Override
    public List<Role> listRoles(String principalName, PrincipalType principalType) throws TException {
        return this.client.listRoles(principalName, principalType);
    }

    @Override
    public List<HiveObjectPrivilege> listPrivileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObjectRef) throws TException {
        return this.client.listPrivileges(principalName, principalType, hiveObjectRef);
    }

    @Override
    public List<String> getRoleNames() throws TException {
        return this.client.getRoleNames();
    }

    @Override
    public void createRole(String roleName, String grantor) throws TException {
        Role role = new Role(roleName, 0, grantor);
        this.client.createRole(role);
    }

    @Override
    public void dropRole(String role) throws TException {
        this.client.dropRole(role);
    }

    @Override
    public boolean grantPrivileges(PrivilegeBag privilegeBag) throws TException {
        return this.client.grantRevokePrivileges(new GrantRevokePrivilegeRequest(GrantRevokeType.GRANT, privilegeBag)).isSuccess();
    }

    @Override
    public boolean revokePrivileges(PrivilegeBag privilegeBag, boolean revokeGrantOption) throws TException {
        GrantRevokePrivilegeRequest grantRevokePrivilegeRequest = new GrantRevokePrivilegeRequest(GrantRevokeType.REVOKE, privilegeBag);
        grantRevokePrivilegeRequest.setRevokeGrantOption(revokeGrantOption);
        return this.client.grantRevokePrivileges(grantRevokePrivilegeRequest).isSuccess();
    }

    @Override
    public void grantRole(String role, String granteeName, PrincipalType granteeType, String grantorName, PrincipalType grantorType, boolean grantOption) throws TException {
        List<RolePrincipalGrant> grants = this.listRoleGrants(granteeName, granteeType);
        for (RolePrincipalGrant grant : grants) {
            if (!grant.getRoleName().equals(role)) continue;
            if (grant.isGrantOption() == grantOption) {
                return;
            }
            if (grant.isGrantOption() || !grantOption) continue;
            this.revokeRole(role, granteeName, granteeType, false);
            break;
        }
        this.createGrant(role, granteeName, granteeType, grantorName, grantorType, grantOption);
    }

    private void createGrant(String role, String granteeName, PrincipalType granteeType, String grantorName, PrincipalType grantorType, boolean grantOption) throws TException {
        GrantRevokeRoleRequest request = new GrantRevokeRoleRequest();
        request.setRequestType(GrantRevokeType.GRANT);
        request.setRoleName(role);
        request.setPrincipalName(granteeName);
        request.setPrincipalType(granteeType);
        request.setGrantor(grantorName);
        request.setGrantorType(grantorType);
        request.setGrantOption(grantOption);
        GrantRevokeRoleResponse response = this.client.grantRevokeRole(request);
        if (!response.isSetSuccess()) {
            throw new MetaException("GrantRevokeResponse missing success field");
        }
    }

    @Override
    public void revokeRole(String role, String granteeName, PrincipalType granteeType, boolean grantOption) throws TException {
        List<RolePrincipalGrant> grants = this.listRoleGrants(granteeName, granteeType);
        RolePrincipalGrant currentGrant = null;
        for (RolePrincipalGrant grant : grants) {
            if (!grant.getRoleName().equals(role)) continue;
            currentGrant = grant;
            break;
        }
        if (currentGrant == null) {
            return;
        }
        if (!currentGrant.isGrantOption() && grantOption) {
            return;
        }
        this.removeGrant(role, granteeName, granteeType, grantOption);
    }

    private void removeGrant(String role, String granteeName, PrincipalType granteeType, boolean grantOption) throws TException {
        GrantRevokeRoleRequest request = new GrantRevokeRoleRequest();
        request.setRequestType(GrantRevokeType.REVOKE);
        request.setRoleName(role);
        request.setPrincipalName(granteeName);
        request.setPrincipalType(granteeType);
        request.setGrantOption(grantOption);
        GrantRevokeRoleResponse response = this.client.grantRevokeRole(request);
        if (!response.isSetSuccess()) {
            throw new MetaException("GrantRevokeResponse missing success field");
        }
    }

    @Override
    public List<RolePrincipalGrant> listGrantedPrincipals(String role) throws TException {
        GetPrincipalsInRoleRequest request = new GetPrincipalsInRoleRequest(role);
        GetPrincipalsInRoleResponse response = this.client.getPrincipalsInRole(request);
        return ImmutableList.copyOf((Collection)response.getPrincipalGrants());
    }

    @Override
    public List<RolePrincipalGrant> listRoleGrants(String principalName, PrincipalType principalType) throws TException {
        GetRoleGrantsForPrincipalRequest request = new GetRoleGrantsForPrincipalRequest(principalName, principalType);
        GetRoleGrantsForPrincipalResponse resp = this.client.getRoleGrantsForPrincipal(request);
        return ImmutableList.copyOf((Collection)resp.getPrincipalGrants());
    }

    @Override
    public void setUGI(String userName) throws TException {
        this.client.setUgi(userName, new ArrayList());
    }

    @Override
    public long openTransaction(String user) throws TException {
        OpenTxnRequest request = new OpenTxnRequest(1, user, this.hostname);
        return (Long)this.client.openTxns(request).getTxnIds().get(0);
    }

    @Override
    public void commitTransaction(long transactionId) throws TException {
        this.client.commitTxn(new CommitTxnRequest(transactionId));
    }

    @Override
    public void abortTransaction(long transactionId) throws TException {
        this.client.abortTxn(new AbortTxnRequest(transactionId));
    }

    @Override
    public void sendTransactionHeartbeat(long transactionId) throws TException {
        HeartbeatTxnRangeRequest request = new HeartbeatTxnRangeRequest(transactionId, transactionId);
        this.client.heartbeatTxnRange(request);
    }

    @Override
    public LockResponse acquireLock(LockRequest lockRequest) throws TException {
        return this.client.lock(lockRequest);
    }

    @Override
    public LockResponse checkLock(long lockId) throws TException {
        return this.client.checkLock(new CheckLockRequest(lockId));
    }

    @Override
    public void unlock(long lockId) throws TException {
        this.client.unlock(new UnlockRequest(lockId));
    }

    @Override
    public String getValidWriteIds(List<String> tableList, long currentTransactionId) throws TException {
        String validTransactions = TxnUtils.createValidReadTxnList(this.client.getOpenTxns(), 0L);
        GetValidWriteIdsRequest request = new GetValidWriteIdsRequest(tableList, validTransactions);
        List validWriteIds = this.client.getValidWriteIds(request).getTblValidWriteIds();
        return TxnUtils.createValidTxnWriteIdList(currentTransactionId, validWriteIds);
    }

    @Override
    public String getConfigValue(String name, String defaultValue) throws TException {
        return this.client.getConfigValue(name, defaultValue);
    }

    @Override
    public String getDelegationToken(String userName) throws TException {
        return this.client.getDelegationToken(userName, userName);
    }

    @Override
    public List<TxnToWriteId> allocateTableWriteIds(String dbName, String tableName, List<Long> transactionIds) throws TException {
        AllocateTableWriteIdsRequest request = new AllocateTableWriteIdsRequest(dbName, tableName);
        request.setTxnIds(transactionIds);
        AllocateTableWriteIdsResponse response = this.client.allocateTableWriteIds(request);
        return response.getTxnToWriteIds();
    }

    @Override
    public void alterPartitions(String dbName, String tableName, List<Partition> partitions, long writeId) throws TException {
        this.alternativeCall(exception -> !ThriftHiveMetastoreClient.isUnknownMethodExceptionalResponse(exception), this.chosenAlterPartitionsAlternative, () -> {
            AlterPartitionsRequest request = new AlterPartitionsRequest(dbName, tableName, partitions);
            request.setWriteId(writeId);
            this.client.alterPartitionsReq(request);
            return null;
        }, () -> {
            this.client.alterPartitionsWithEnvironmentContext(dbName, tableName, partitions, new EnvironmentContext());
            return null;
        });
    }

    @Override
    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) throws TException {
        AddDynamicPartitions request = new AddDynamicPartitions(transactionId, writeId, dbName, tableName, partitionNames);
        request.setOperationType(operation.getMetastoreOperationType());
        this.client.addDynamicPartitions(request);
    }

    @Override
    public void alterTransactionalTable(Table table, long transactionId, long writeId, EnvironmentContext environmentContext) throws TException {
        long originalWriteId = table.getWriteId();
        this.alternativeCall(exception -> !ThriftHiveMetastoreClient.isUnknownMethodExceptionalResponse(exception), this.chosenAlterTransactionalTableAlternative, () -> {
            table.setWriteId(writeId);
            Preconditions.checkArgument((writeId >= table.getWriteId() ? 1 : 0) != 0, (String)"The writeId supplied %s should be greater than or equal to the table writeId %s", (long)writeId, (long)table.getWriteId());
            AlterTableRequest request = new AlterTableRequest(table.getDbName(), table.getTableName(), table);
            request.setValidWriteIdList(this.getValidWriteIds((List<String>)ImmutableList.of((Object)String.format("%s.%s", table.getDbName(), table.getTableName())), transactionId));
            request.setWriteId(writeId);
            request.setEnvironmentContext(environmentContext);
            this.client.alterTableReq(request);
            return null;
        }, () -> {
            table.setWriteId(originalWriteId);
            this.client.alterTableWithEnvironmentContext(table.getDbName(), table.getTableName(), table, environmentContext);
            return null;
        });
    }

    @SafeVarargs
    @VisibleForTesting
    final <T> T alternativeCall(Predicate<Exception> isValidExceptionalResponse, AtomicInteger chosenAlternative, AlternativeCall<T> ... alternatives) throws TException {
        Preconditions.checkArgument((alternatives.length > 0 ? 1 : 0) != 0, (Object)"No alternatives");
        int chosen = chosenAlternative.get();
        Preconditions.checkArgument((chosen == Integer.MAX_VALUE || 0 <= chosen && chosen < alternatives.length ? 1 : 0) != 0, (String)"Bad chosen alternative value: %s", (int)chosen);
        if (chosen != Integer.MAX_VALUE) {
            return alternatives[chosen].execute();
        }
        Throwable firstException = null;
        for (int i = 0; i < alternatives.length; ++i) {
            int position = i;
            try {
                T result = alternatives[i].execute();
                chosenAlternative.updateAndGet(currentChosen -> Math.min(currentChosen, position));
                return result;
            }
            catch (RuntimeException | TException exception) {
                if (isValidExceptionalResponse.test((Exception)exception)) {
                    throw exception;
                }
                if (firstException == null) {
                    firstException = exception;
                } else if (firstException != exception) {
                    firstException.addSuppressed(exception);
                }
                this.disconnect();
                this.connect();
                continue;
            }
        }
        Verify.verifyNotNull(firstException);
        Throwables.propagateIfPossible(firstException, TException.class);
        throw ThriftHiveMetastoreClient.propagate(firstException);
    }

    private static boolean defaultIsValidExceptionalResponse(Exception exception) {
        if (exception instanceof NoSuchObjectException) {
            return true;
        }
        return exception.toString().contains("AccessControlException");
    }

    private static boolean isUnknownMethodExceptionalResponse(Exception exception) {
        if (!(exception instanceof TApplicationException)) {
            return false;
        }
        TApplicationException applicationException = (TApplicationException)exception;
        return applicationException.getType() == 1;
    }

    private static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }

    public static interface TransportSupplier {
        public TTransport createTransport() throws TTransportException;
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface AlternativeCall<T> {
        public T execute() throws TException;
    }

    @FunctionalInterface
    private static interface UnaryCall<A> {
        public void call(A var1) throws TException;
    }
}

