/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory.context;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.io.Closer;
import com.google.errorprone.annotations.ThreadSafe;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import java.io.IOException;
import java.util.Objects;

@ThreadSafe
public final class MemoryTrackingContext {
    private final AggregatedMemoryContext userAggregateMemoryContext;
    private final AggregatedMemoryContext revocableAggregateMemoryContext;
    private LocalMemoryContext userLocalMemoryContext;
    private LocalMemoryContext revocableLocalMemoryContext;

    public MemoryTrackingContext(AggregatedMemoryContext userAggregateMemoryContext, AggregatedMemoryContext revocableAggregateMemoryContext) {
        this.userAggregateMemoryContext = Objects.requireNonNull(userAggregateMemoryContext, "userAggregateMemoryContext is null");
        this.revocableAggregateMemoryContext = Objects.requireNonNull(revocableAggregateMemoryContext, "revocableAggregateMemoryContext is null");
    }

    public void close() {
        try (Closer closer = Closer.create();){
            closer.register(this.userAggregateMemoryContext::close);
            closer.register(this.revocableAggregateMemoryContext::close);
            closer.register(this.userLocalMemoryContext::close);
            closer.register(this.revocableLocalMemoryContext::close);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception closing memory tracking context", e);
        }
    }

    public LocalMemoryContext localUserMemoryContext() {
        Verify.verifyNotNull((Object)this.userLocalMemoryContext, (String)"local memory contexts are not initialized", (Object[])new Object[0]);
        return this.userLocalMemoryContext;
    }

    public LocalMemoryContext localRevocableMemoryContext() {
        Verify.verifyNotNull((Object)this.revocableLocalMemoryContext, (String)"local memory contexts are not initialized", (Object[])new Object[0]);
        return this.revocableLocalMemoryContext;
    }

    public LocalMemoryContext newUserMemoryContext(String allocationTag) {
        return this.userAggregateMemoryContext.newLocalMemoryContext(allocationTag);
    }

    public AggregatedMemoryContext aggregateUserMemoryContext() {
        return this.userAggregateMemoryContext;
    }

    public AggregatedMemoryContext aggregateRevocableMemoryContext() {
        return this.revocableAggregateMemoryContext;
    }

    public AggregatedMemoryContext newAggregateUserMemoryContext() {
        return this.userAggregateMemoryContext.newAggregatedMemoryContext();
    }

    public AggregatedMemoryContext newAggregateRevocableMemoryContext() {
        return this.revocableAggregateMemoryContext.newAggregatedMemoryContext();
    }

    public long getUserMemory() {
        return this.userAggregateMemoryContext.getBytes();
    }

    public long getRevocableMemory() {
        return this.revocableAggregateMemoryContext.getBytes();
    }

    public MemoryTrackingContext newMemoryTrackingContext() {
        return new MemoryTrackingContext(this.userAggregateMemoryContext.newAggregatedMemoryContext(), this.revocableAggregateMemoryContext.newAggregatedMemoryContext());
    }

    public void initializeLocalMemoryContexts(String allocationTag) {
        this.userLocalMemoryContext = this.userAggregateMemoryContext.newLocalMemoryContext(allocationTag);
        this.revocableLocalMemoryContext = this.revocableAggregateMemoryContext.newLocalMemoryContext(allocationTag);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("userAggregateMemoryContext", (Object)this.userAggregateMemoryContext).add("revocableAggregateMemoryContext", (Object)this.revocableAggregateMemoryContext).add("userLocalMemoryContext", (Object)this.userLocalMemoryContext).add("revocableLocalMemoryContext", (Object)this.revocableLocalMemoryContext).toString();
    }
}

